﻿using Curse.SocketMessages;
using ProtoBuf;

namespace Curse.Voice.Contracts
{
    [ProtoContract]
    public class VoiceSessionMember : Contract<VoiceSessionMember>
    {
        /// <summary>
        /// Per-session ID, related to the connection
        /// </summary>
        [ProtoMember(1)]
        public int ClientID { get; set; }

        /// <summary>
        /// Curse ID
        /// </summary>
        [ProtoMember(2)]
        public int? UserID { get; set; }

        [ProtoMember(3)]
        public string DisplayName { get; set; }

        [ProtoMember(4)]
        public string AvatarUrl { get; set; }

        [ProtoMember(5)]
        public string SmallAvatarUrl { get; set; }

        [ProtoMember(6)]
        public string InGameName { get; set; }

        [ProtoMember(7)]
        public string InGameRegion { get; set; }

        [ProtoMember(8)]
        public CodecInfo CodecInfo { get; set; }

        [ProtoMember(9)]
        public bool IsModMuted { get; set; }

        [ProtoMember(10)]
        public bool IsModDeafened { get; set; }

        [ProtoMember(11)]
        public bool CanSpeak { get; set; }

        [ProtoMember(12)]
        public CodecInfo VideoCodec { get; set; }
    }
}
