﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using NUnit.Framework;

namespace Curse.Voice.Core.Tests
{
    [TestFixture]
    public class VoiceManagerTests
    {
        [TestCase("a1b1", "http://beta.cursevoice.com/join/a1b1")]
        [TestCase("a1b1", "http://br.cursevoice.com/join/a1b1")]
        [TestCase("a1b1", "http://cursevoice.com/join/a1b1")]
        [TestCase("a1b1", " blah http://beta.cursevoice.com/join/a1b1 blah ")]
        [TestCase("a1b1", "  a1b1 ")]
        [TestCase("a1b1", "cursevoice.com/join/a1b1")]
        [TestCase("a1b2c3", "a1b2c3")]
        //[TestCase("a1b2c3d4e5", "a1b2c3d4e5")]

        [TestCase("a1b1", "http://cv.gg/a1b1")]
        [TestCase("a1b1", "http://br.cv.gg/a1b1")]
        [TestCase("a1b1", "Reallylongtext cv.gg/a1b1")]

        [TestCase(null, null)]
        [TestCase(null, "")]
        [TestCase(null, "a1b")]                 // too short
        [TestCase(null, "  a1b  ")]
        [TestCase(null, "a1b2c3d")]             // too long (7)
        [TestCase(null, "a1b2c3d4e5f")]         // too long (11)
        [TestCase(null, "http://beta.cursevoice.com/join/")]
        [TestCase(null, "http://br.cv.gg/")]
        public void FindJoinCodeTests(string expected, string url)
        {
            Assert.AreEqual(expected, VoiceManager.Instance.FindJoinCode(url));
        }

        [TestCase("a1b1", "  a1b1  ")]
        [TestCase("http://cv.gg/a1b1", "http://cv.gg/a1b1")]
        [TestCase("http://cv.gg/a1b1", "http://cv.gg/a1b1")]
        [TestCase("http://cv.gg/a1b1", "Join me at http://cv.gg/a1b1 to chat")]
        public void FindJoinStringTests(string expected, string url)
        {
            Assert.AreEqual(expected, VoiceManager.Instance.FindJoinUrl(url));
        }
    }
}
