﻿using Curse.Logging;
using Curse.Voice.Service.Models;
using System;
using System.Configuration;
using System.IO;
using System.Reflection;
using System.Xml.Serialization;

namespace Curse.Voice.Service
{
    public enum ConfigurationMode
    {
        Debug,
        Staging,        
        Alpha,        
        Beta,
        Release,
        LoadTesting
    }

    
    [XmlType("CoreService")]
    public class CoreServiceConfiguration
    {
        public static ConfigurationMode Mode { get; private set; }

        private static readonly CoreServiceConfiguration _instance = null;

        public static CoreServiceConfiguration Instance
        {
            get { return _instance; }
        }

        static CoreServiceConfiguration()
        {

#if CONFIG_DEBUG
            Mode = ConfigurationMode.Debug;
#elif CONFIG_STAGING
            Mode = ConfigurationMode.Staging;
#elif CONFIG_BETA
            Mode = ConfigurationMode.Beta;
#elif CONFIG_RELEASE
            Mode = ConfigurationMode.Release;
#elif CONFIG_LOADTESTING
            Mode = ConfigurationMode.LoadTesting;
#endif
            Logger.Info("Current configuration is: " + Mode);

            // Try to load the config, based on the compilation mode
            var configPath = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "Configuration", "CoreService." + Mode.ToString() + ".config");

            Logger.Info("Loading service configuration from: " + configPath);

            if (!File.Exists(configPath))
            {
                throw new ConfigurationErrorsException("Configuration could not be loaded from '" + configPath + "'");
            }

            using (var reader = new StreamReader(configPath))
            {
                var dcs = new XmlSerializer(typeof(CoreServiceConfiguration));
                _instance = (CoreServiceConfiguration)dcs.Deserialize(reader);
            }
            
        }

        [XmlElement()]        
        public int HostPortNumber { get; set; }

        [XmlElement()]
        public int VoicePortNumber { get; set; }

        [XmlElement()]
        public string ConnectionString { get; set; }

        [XmlElement()]
        public string ReportingConnectionString { get; set; }        

        [XmlElement()]
        public string InviteUrlFormat { get; set; }

        [XmlElement()]
        public VoiceHostEnvironment Environment { get; set; }

        [XmlElement()]
        public int MaximumConnectionsPerHost { get; set; }

        [XmlElement()]
        public double MaximumBandwithBitsPerSecond { get; set; }

        [XmlElement()]
        public string ApiKey { get; set; }
        
        [XmlElement()]
        public string AuthServiceUrl { get; set; }

        [XmlElement()]
        public int AuthSiteID { get; set; }

        [XmlElement()]
        public string AuthSiteKey { get; set; }

        [XmlElement()]
        public int MaxJoinFailures { get; set; }

        [XmlElement()]
        public int BanDurationMinutes { get; set; }

        [XmlElement()]
        public string HostDomainName { get; set; }

        [XmlElement()]
        public string CloudFlareApiKey { get; set; }

        [XmlElement()]
        public string CloudFlareApiEmailAddress { get; set; }

        [XmlElement()]
        public string EncryptionKey { get; set; }

        [XmlElement()]
        public int EncryptionIterations { get; set; }

        [XmlElement()]
        public bool AuthLevelDisabled { get; set; }

        [XmlElement]
        public string JobMachineName { get; set; }

        [XmlElement]
        public bool SaveLogsToDatabase { get; set; }

        [XmlElement]
        public bool SaveLogsToService { get; set; }

        [XmlElement]
        public string LogServiceApiKey { get; set; }

        [XmlElement]
        public string LogServiceUploadUri { get; set; }

        [XmlElement]
        public string TrustedCloudflareRangesSource { get; set; }

        [XmlElement]
        public string TrustedIpRanges { get; set; }
    }
}
