﻿using Curse.Caching;
using Curse.Logging;
using Curse.ServiceAuthentication;
using Curse.Voice.Helpers;
using System;
using System.Configuration;
using System.Data.SqlClient;
using System.Threading.Tasks;
using Curse.CloudFlare;
using Curse.Voice.Service.GeoCoding;
using Curse.Voice.Service.Helpers;
using Curse.Voice.Service.Utilities;
using Curse.ServiceEncryption;

namespace Curse.Voice.Service
{
    public class Global : System.Web.HttpApplication
    {
        
        protected void Application_Start(object sender, EventArgs e)
        {
            try
            {                
                LogUtility.Initialize();

                EncryptionToken.Initialize(CoreServiceConfiguration.Instance.EncryptionKey, CoreServiceConfiguration.Instance.EncryptionIterations);
                
                DatabaseHelper.Instance.Initialize(CoreServiceConfiguration.Instance.ConnectionString);

                CloudFlareApi.Initialize(CoreServiceConfiguration.Instance.CloudFlareApiKey, CoreServiceConfiguration.Instance.CloudFlareApiEmailAddress);

                var dnsName = System.Net.Dns.GetHostName();
                Logger.Info("Cental Voice Service Starting at " + dnsName);

                Logger.Info("Cluster Manager Initializing...");
                
                try
                {
                    using (var conn = DatabaseHelper.Instance.GetConnection())
                    {
                        ClusterManager.Instance.Initialize("CurseVoiceService", conn);
                    }

                }
                catch (Exception ex)
                {
                    Logger.Error(ex, "Cache Cluster Failed to Initialize!");
                }

                Logger.Info("Cache Cluster Initializing...");
                
                try
                {
                    CacheCluster.Instance.Start();
                }
                catch (Exception ex)
                {
                    Logger.Error(ex, "Failed to start cache cluster!");
                }

                Logger.Info("Initializing Geo IP Services");
                try
                {
#if !DEBUG || DEBUG_GEO                
                IPDatabaseUpdater.Initialize();
#endif
                }
                catch
                {
                    Logger.Info("Failed to initialize Geo IP Services. See error log for details.");
                    throw;
                }

#if DEBUG
                Task.Factory.StartNew(IPRange.Initialize);                
#else
                IPRange.Initialize();
#endif

                Logger.Info("Initializing Authentication Provider...");

                var logDelegate = new LogDelegate((m, ex, data) =>
                {
                    if (ex == null)
                    {
                        Logger.Info(m, data);
                    }
                    else
                    {
                        Logger.Error(ex, m, data);
                    }
                });

                AuthenticationProvider.Initialize(
                    CoreServiceConfiguration.Instance.AuthServiceUrl,
                    logDelegate,
                    CoreServiceConfiguration.Instance.AuthSiteID,
                    CoreServiceConfiguration.Instance.AuthSiteKey,
                    CoreServiceConfiguration.Instance.ApiKey,
                    false,
                    false, 
                    null,
                    CoreServiceConfiguration.Instance.AuthLevelDisabled,
                    false);

                Logger.Info("Initializing Reporting Helper");
                ReportingHelper.Initialize();
                Logger.Info("Reporting Helper Initialized");

                Logger.Info("Initializing Voice Host Manager");
                try
                {
                    VoiceHostManager.Instance.Initialize();
                }
                catch (Exception ex)
                {
                    Logger.Error(ex, "Failed to initialize Voice Host Manager. See error log for details.");
                    throw;
                }

                Logger.Info("Initializing Logging Helper");
                LoggingHelper.Initialize();                
            }
            catch (Exception ex)
            {
                Logger.Error(ex, "Service Failed to Start!");
                throw;
            }

            Logger.Info("Service Started");            
        }

        protected void Session_Start(object sender, EventArgs e)
        {

        }

        protected void Application_BeginRequest(object sender, EventArgs e)
        {

        }

        protected void Application_AuthenticateRequest(object sender, EventArgs e)
        {

        }

        protected void Application_Error(object sender, EventArgs e)
        {

        }

        protected void Session_End(object sender, EventArgs e)
        {

        }

        protected void Application_End(object sender, EventArgs e)
        {
            Logger.Info("Service is ending");

            Logger.Info("Disposing Cache Cluster...");
            try
            {

                CacheCluster.Instance.Dispose();
                Logger.Info("Cache Cluster Disposed!");
            }
            catch (Exception ex)
            {
                Logger.Warn(ex, "Failed to dispose of cache cluster!");
            }                      
            
        }
    }
}