﻿using System.Net.Security;
using System.ServiceModel;
using System.ServiceModel.Web;
using Curse.Voice.Service.Models;
using Curse.Voice.Service.Responses;
using Curse.Voice.Contracts;

namespace Curse.Voice.Service
{
    [ServiceContract(ProtectionLevel = ProtectionLevel.None)]
    public interface ICurseVoiceMonitor
    {
        [OperationContract]
        [WebGet(BodyStyle = WebMessageBodyStyle.Wrapped, UriTemplate = "get-host-configurations?apiKey={apiKey}", ResponseFormat = WebMessageFormat.Json)]
        VoiceHostConfiguration[] GetHostConfigurations(string apiKey);

        [OperationContract]
        [WebGet(BodyStyle = WebMessageBodyStyle.Wrapped, UriTemplate = "get-current-voice-hosts?apiKey={apiKey}", ResponseFormat = WebMessageFormat.Json)]
        CurrentVoiceHostsResponse GetCurrentVoiceHosts(string apiKey);

        [OperationContract]
        [WebGet(BodyStyle = WebMessageBodyStyle.Wrapped, UriTemplate = "get-host-details?apiKey={apiKey}&id={id}", ResponseFormat = WebMessageFormat.Json)]
        VoiceHostDetailsResponse GetHostDetails(string apiKey, int id);

        [OperationContract]
        [WebGet(BodyStyle = WebMessageBodyStyle.Wrapped, UriTemplate = "get-host-connection-diagnostics?apiKey={apiKey}&id={id}", ResponseFormat = WebMessageFormat.Json)]
        HostConnectionDiagnosticsResponse GetHostConnectionDiagnostics(string apiKey, int id);

        [OperationContract]
        [WebGet(BodyStyle = WebMessageBodyStyle.Wrapped, UriTemplate = "get-voice-instance-types?apiKey={apiKey}", ResponseFormat = WebMessageFormat.Json)]
        VoiceInstanceType[] GetVoiceInstanceTypes(string apiKey);
    }
}
