﻿using System;
using System.Net;
using System.Net.Security;
using System.ServiceModel;
using System.ServiceModel.Web;
using Curse.Voice.HostManagement.Models;
using Curse.Voice.Service.Models;
using Curse.Voice.Service.Responses;
using Curse.ServiceAuthentication;
using Curse.Voice.Contracts;
using Curse.Voice.Service.Requests;
using Curse.Voice.Service.ServiceModels;

namespace Curse.Voice.Service
{
    [ServiceContract(ProtectionLevel = ProtectionLevel.None)]
    public interface ICurseVoiceService
    {

        

        [OperationContract]
        [WebInvoke(BodyStyle = WebMessageBodyStyle.Wrapped)]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        CreateVoiceSessionResponse CreateVoiceSession(string userDisplayName, int? gameID, int? userID, bool destroyExistingSession, Version clientVersion);

        #region Server to Server API Methods

        [OperationContract]
        [WebInvoke(BodyStyle = WebMessageBodyStyle.Wrapped)]
        CreateVoiceSessionResponse GroupVoiceSession(string apiKey, IPAddress ipAddress, Version clientVersion, int userID, string groupName, Guid groupID, bool forceNewSession);

        [OperationContract]
        [WebInvoke(BodyStyle = WebMessageBodyStyle.Wrapped)]
        CreateVoiceSessionResponse FriendVoiceSession(string apiKey, IPAddress ipAddress, Version clientVersion, int userID, string username, int friendID, bool forceNewSession);

        [OperationContract]
        [WebInvoke(BodyStyle = WebMessageBodyStyle.Wrapped)]
        UnlockVoiceSessionResponse UnlockVoiceSession(string apiKey, IPAddress ipAddress, string sessionCode, int userID);

        [OperationContract]
        [WebInvoke(BodyStyle = WebMessageBodyStyle.Wrapped)]
        KickUsersFromGroupCallResponse KickUsersFromGroupCall(string apiKey, IPAddress address, Guid groupID, int kickerID, int[] usersToKick);

        [OperationContract]
        [WebInvoke(BodyStyle = WebMessageBodyStyle.Wrapped)]
        RemoveUsersFromGroupCallResponse RemoveUsersFromGroupCall(string apiKey, IPAddress address, Guid groupID, int requestorID, int[] usersToRemove, UserDisconnectReason reason);

        [OperationContract]
        [WebInvoke(BodyStyle = WebMessageBodyStyle.Wrapped)]
        BasicVoiceServiceResponse AddPendingVoiceUsers(string apiKey, IPAddress ipAddress, string sessionCode, int userID, PendingUserRequest[] pendingUsers);

        [OperationContract]
        [WebInvoke(BodyStyle = WebMessageBodyStyle.Wrapped)]
        BasicVoiceServiceResponse RemovePendingVoiceUser(string apiKey, IPAddress ipAddress, string inviteCode, int userID);

        [OperationContract]
        [WebInvoke(BodyStyle = WebMessageBodyStyle.Wrapped)]
        [RequiresAuthentication(AccessLevel.Anonymous)]
        FindVoiceSessionResponse FindVoiceSession(string apiKey, string inviteCode);

        [OperationContract]
        [WebInvoke(BodyStyle = WebMessageBodyStyle.Wrapped)]
        [RequiresAuthentication(AccessLevel.Anonymous)]
        VoiceInstanceDetailsResponse GetVoiceInstanceDetails(string apiKey, string callID);
        
        [OperationContract]
        [WebInvoke(BodyStyle = WebMessageBodyStyle.Wrapped)]
        RegisterVoiceHostResponse RegisterVoiceHost(string apiKey, string externalID, string hostName, Version version);

        [OperationContract]
        [WebInvoke(BodyStyle = WebMessageBodyStyle.Wrapped)]
        RegisterVoiceHostResponse RegisterVoiceHostV2(string apiKey, string externalID, string hostName, Version version, VoiceInstanceMode supportedModes);

        [OperationContract]
        [WebInvoke(BodyStyle = WebMessageBodyStyle.Wrapped)]
        VoiceHostConfigurationResponse GetVoiceHostConfiguration(string apiKey, string externalID);

        [OperationContract]
        [WebInvoke(BodyStyle = WebMessageBodyStyle.Wrapped)]
        BasicVoiceServiceResponse FailoverHost(string apiKey, int hostID);

        [OperationContract]
        [WebInvoke(BodyStyle = WebMessageBodyStyle.Wrapped)]
        ShutdownHostResponse ShutdownVoiceHost(string apiKey, string externalID);

        [OperationContract]
        bool UploadLogData(LogDataPayload payload);

        [OperationContract]
        [WebGet(UriTemplate = "health-check")]
        string HealthCheck();

        [OperationContract]
        [WebInvoke(BodyStyle = WebMessageBodyStyle.Wrapped)]
        CreateVoiceSessionResponse CreateVoiceSessionOnHost(string apiKey, string userDisplayName, int userID, int hostID);

        [OperationContract]
        [WebInvoke(BodyStyle = WebMessageBodyStyle.Wrapped)]
        bool PruneHandshakes(string apiKey);

        [OperationContract]
        [WebInvoke(BodyStyle = WebMessageBodyStyle.Wrapped)]
        bool PruneInstances(string apiKey);

        [OperationContract]
        [WebInvoke(BodyStyle = WebMessageBodyStyle.Wrapped)]
        bool UpdateInstancesWithMaxUsers(string apiKey, UpdateInstanceUserCountRequest[] updatedCounts);
        #endregion

        [OperationContract]
        [WebInvoke(RequestFormat = WebMessageFormat.Json, BodyStyle = WebMessageBodyStyle.WrappedRequest)]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        GetVoiceSessionResponse GetVoiceSession(string inviteCode, Version clientVersion);
        
        #region Game Session Reporting

        [OperationContract]
        [WebInvoke(BodyStyle = WebMessageBodyStyle.Wrapped)]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        ReportGameSessionsResponse ReportGameSessions(GameSessionMetric[] metrics);

        #endregion

        #region Automatching

        [OperationContract]
        [WebInvoke(BodyStyle = WebMessageBodyStyle.Wrapped)]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        AutoMatchVoiceSessionResponse AutoMatchVoiceSession(string userDisplayName, int? gameID, Version clientVersion, Int64 autoMatchKey);

        [OperationContract]
        [WebInvoke(BodyStyle = WebMessageBodyStyle.Wrapped)]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        AutoMatchHandshakeResponse AutoMatchHandshake(int attempt, Int64 autoMatchKey);

        [OperationContract]
        [WebInvoke(BodyStyle = WebMessageBodyStyle.Wrapped)]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        AutoMatchHandshakeResponse AutoMatchHandshakeByDisplayName(int attempt, Int64 autoMatchKey, string displayName, int? gameID);

        [OperationContract]
        [WebInvoke(BodyStyle = WebMessageBodyStyle.Wrapped)]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        DeclineAutoMatchResponse DeclineAutoMatch(Int64 autoMatchKey);

        #endregion

        #region Game Reporting

        [OperationContract]
        [WebInvoke(BodyStyle = WebMessageBodyStyle.Wrapped)]
        [RequiresAuthentication(AccessLevel.Authenticated)]
        BasicVoiceServiceResponse ReportGameState(string sessionGuid, int gameID);

        #endregion

        #region V2 Methods

        [OperationContract]
        [WebInvoke(BodyStyle = WebMessageBodyStyle.Wrapped)]
        AutoMatchHandshakeResponse AutoMatchHandshakeByDisplayNameV2(string apiKey, int userID, int attempt, long autoMatchKey, string displayName, int? gameID);

        [OperationContract]
        [WebInvoke(BodyStyle = WebMessageBodyStyle.Wrapped)]
        DeclineAutoMatchResponse DeclineAutoMatchV2(string apiKey, int userID, long autoMatchKey);

        [OperationContract]
        [WebInvoke(BodyStyle = WebMessageBodyStyle.Wrapped)]
        ProvisionVoiceSessionResponse FriendVoiceSessionV2(string apiKey, IPAddress ipAddress, Version clientVersion, int userID, string username, int friendID, bool forceNewSession, PendingUserRequest pendingUser);

        [OperationContract]
        [WebInvoke(BodyStyle = WebMessageBodyStyle.Wrapped)]
        ProvisionVoiceSessionResponse GroupVoiceSessionV2(string apiKey, IPAddress ipAddress, Version clientVersion, int userID, string groupName, Guid groupID, bool forceNewSession, int preferredRegion = 0);

        [OperationContract]
        [WebInvoke(BodyStyle = WebMessageBodyStyle.Wrapped)]
        ProvisionVoiceSessionResponse AdHocVoiceSessionV2(string apiKey, string userDisplayName, int? gameID, int userID, bool destroyExistingSession, Version clientVersion, IPAddress ipAddress = null);
        
        [OperationContract]
        [WebInvoke(BodyStyle = WebMessageBodyStyle.Wrapped)]
        [RequiresAuthentication(AccessLevel.Anonymous)]
        VoiceInstanceDetailsResponse FindVoiceSessionV2(string apiKey, string inviteCode);

        [OperationContract]
        [WebInvoke(BodyStyle = WebMessageBodyStyle.Wrapped)]
        [RequiresAuthentication(AccessLevel.Anonymous)]
        AddPendingVoiceUsersResponse AddPendingVoiceUsersV2(string apiKey, IPAddress ipAddress, string instanceGuid, int userID, PendingUserRequest[] pendingUsers);

        [OperationContract]
        [WebInvoke(RequestFormat = WebMessageFormat.Json, BodyStyle = WebMessageBodyStyle.Wrapped)]
        BasicVoiceServiceResponse KickUserV2(string apiKey, string callID, int requestorUserID, int kickedUserID);

        [OperationContract]
        [WebInvoke(RequestFormat = WebMessageFormat.Json, BodyStyle = WebMessageBodyStyle.Wrapped)]
        BasicVoiceServiceResponse MuteUserV2(string apiKey, string instanceGuid, int requestorUserID, int mutedUserID, bool mute);

        [OperationContract]
        [WebInvoke(RequestFormat = WebMessageFormat.Json, BodyStyle = WebMessageBodyStyle.Wrapped)]
        BasicVoiceServiceResponse DeafenUserV2(string apiKey, string instanceGuid, int requestorUserID, int deafenedUserID, bool deafen);

        [OperationContract]
        [WebInvoke(RequestFormat = WebMessageFormat.Json, BodyStyle = WebMessageBodyStyle.Wrapped)]
        BasicVoiceServiceResponse UpdatePermissionsV2(string apiKey, Guid groupID, VoiceUserPermissions[] userPermissions);

        [OperationContract]
        [WebInvoke(RequestFormat = WebMessageFormat.Json, BodyStyle = WebMessageBodyStyle.Wrapped)]
        ProvisionVoiceSessionResponse AutoMatchVoiceSessionV2(string userDisplayName, int? gameID, IPAddress ipAddress, Version clientVersion, Int64 autoMatchKey);

        [OperationContract]
        [WebInvoke(BodyStyle = WebMessageBodyStyle.Wrapped)]
        BasicVoiceServiceResponse ReportGameStateV2(string apiKey, string sessionGuid, int gameID);

        [OperationContract]
        [WebInvoke(BodyStyle = WebMessageBodyStyle.Wrapped)]
        ReportGameSessionsResponse ReportGameSessionsV2(string apiKey, int userID, GameSessionMetric[] metrics);

        #endregion

        #region V3 Methods


        [OperationContract]
        [WebInvoke(BodyStyle = WebMessageBodyStyle.Wrapped)]
        ProvisionVoiceSessionResponse FriendVoiceSessionV3(string apiKey, IPAddress ipAddress, Version clientVersion, int userID, string username, int friendID, bool forceNewSession, PendingUserRequest pendingUser, VoiceInstanceMode mode);

        [OperationContract]
        [WebInvoke(BodyStyle = WebMessageBodyStyle.Wrapped)]
        ProvisionVoiceSessionResponse GroupVoiceSessionV3(string apiKey, IPAddress ipAddress, Version clientVersion, int userID, string groupName, Guid groupID, bool forceNewSession, int preferredRegion, VoiceInstanceMode mode);

        [OperationContract]
        [WebInvoke(BodyStyle = WebMessageBodyStyle.Wrapped)]        
        ChangeVoiceSessionModeResponse ChangeVoiceSessionMode(string apiKey, IPAddress ipAddress, string sessionCode, int userID, VoiceInstanceMode mode);

        #endregion

        [OperationContract]
        [WebInvoke(RequestFormat = WebMessageFormat.Json, BodyStyle = WebMessageBodyStyle.Wrapped)]
        int GetFriendsServiceRegionForIP(string ipAddress, string apiKey);

#if DEBUG

        [OperationContract]
        [WebInvoke(BodyStyle = WebMessageBodyStyle.Wrapped)]
        string TestDatabaseModels();

        [OperationContract]
        [WebInvoke(BodyStyle = WebMessageBodyStyle.Wrapped)]
        string TestIPAddress(string ipAddress);

#endif

      

       
    }
}
