﻿using System.ServiceModel;
using Curse.Voice.Service.Models;
using Curse.Voice.Service.ServiceModels;
using Curse.Voice.UpdateManagement;

namespace Curse.Voice.Service
{
    // NOTE: You can use the "Rename" command on the "Refactor" menu to change the interface name "IHostUpdateService" in both code and config file together.
    [ServiceContract()]
    public interface IHostUpdateService
    {
        [OperationContract]
        UpdatePayloadResult UploadUpdate(UpdatePayload payload);

        [OperationContract]
        VoiceHostUpdateResult DeployUpdate(VoiceHostUpdateRequest request);

        [OperationContract]
        bool CancelUpdate(string apiKey, int jobID);

        [OperationContract]
        UpdateRolloutResult GetUpdateStatus(string apiKey, int jobID);

        [OperationContract]
        bool RegisterClientVersion(string apiKey, VoiceHostEnvironment environment, string versionString);

        [OperationContract]
        VoiceHostDeploymentStatus GetDeploymentStatus(string apiKey, int jobID);
    }
}
