﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using System.Linq;
using System.Web;
using Curse.ServiceAuthentication.AuthenticationService;

namespace Curse.Voice.Service.Models
{
    public class VoiceHandshakeUser
    {
        public int UserID { get; set; }
        public string DisplayName { get; set; }
        public DateTime Timestamp { get; set; }
        public bool Declined { get; set; }
        public bool IsRecent { get; set; }

        public VoiceHandshakeUser()
        {

        }

        public VoiceHandshakeUser(SqlDataReader reader)
        {
            UserID = (int)reader["UserID"];
            DisplayName = (string)reader["DisplayName"];
            Timestamp = (DateTime)reader["Timestamp"];
            Declined = (bool)reader["Declined"];
            IsRecent = (DateTime.UtcNow - Timestamp).TotalMinutes <= 10;
        }
    }
}