﻿using Curse.Caching;
using Curse.Logging;
using Curse.Voice.Helpers;
using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using Curse.Voice.Contracts;

namespace Curse.Voice.Service.Models
{
    public class VoiceHostConfiguration
    {
        public int ID { get; set; }
        public string Description { get; set; }
        public int MaximumSessions { get; set; }
        public int MaximumConnections { get; set; }
        public int MaximumOutboundBbps { get; set; }
        public int MaximumInboundBbps { get; set; }
        public bool IsDefault { get; set; }
        public int MaxUsersPerSession { get; set; }
        public VoiceInstanceMode Mode { get; set; }

        static VoiceHostConfiguration()
        {
            using (var connection = DatabaseHelper.Instance.GetConnection())
            {
                using (var command = connection.CreateCommand())
                {
                    command.CommandText = "SELECT TOP 1 ID FROM [VoiceHostConfiguration] WHERE IsDefault = 1 AND Mode = " + (int)VoiceInstanceMode.Audio;
                    _defaultVoiceConfigurationID = (int)command.ExecuteScalar();
                }

                using (var command = connection.CreateCommand())
                {
                    command.CommandText = "SELECT TOP 1 ID FROM [VoiceHostConfiguration] WHERE IsDefault = 1 AND Mode = " + (int)VoiceInstanceMode.Video;
                    _defaultVideoConfigurationID = (int)command.ExecuteScalar();
                }
            }
        }

        private static readonly int _defaultVoiceConfigurationID;
        private static readonly int _defaultVideoConfigurationID;

        public static VoiceHostConfiguration DefaultVoice
        {
            get { return GetByID(_defaultVoiceConfigurationID); }            
        }

        public static VoiceHostConfiguration DefaultVideo
        {
            get { return GetByID(_defaultVideoConfigurationID); }

        }

        public VoiceHostConfiguration() { }

   
        public VoiceHostConfiguration(SqlDataReader reader)
        {
            ID = (int)reader["ID"];
            Description = (string)reader["Description"];
            MaximumSessions = (int)reader["MaximumSessions"];
            MaximumConnections = (int)reader["MaximumConnections"];
            MaximumOutboundBbps = (int)reader["MaximumOutboundBbps"];
            MaximumInboundBbps = (int)reader["MaximumOutboundBbps"];
            IsDefault = (bool)reader["IsDefault"];
            MaxUsersPerSession = (int)reader["MaxUsersPerSession"];
            Mode = (VoiceInstanceMode)(byte)reader["Mode"];
        }

        public static VoiceHostConfiguration GetFromDatabaseByID(int id)
        {
            using (var connection = DatabaseHelper.Instance.GetConnection())
            {
                using (var command = connection.CreateCommand())
                {
                    command.CommandText = "SELECT * FROM [VoiceHostConfiguration] WHERE ID = @ID";
                    command.Parameters.AddWithValue("@ID", id);

                    using (var reader = command.ExecuteReader())
                    {
                        if (reader.Read())
                        {
                            return new VoiceHostConfiguration(reader);
                        }

                        return null;
                    }
                }
            }
        }

        public bool Save(SqlConnection connection, SqlTransaction transaction)
        {
            using (var command = connection.CreateCommand())
            {
                command.Transaction = transaction;
                command.Parameters.AddWithValue("@Description", Description);
                command.Parameters.AddWithValue("@MaximumSessions", MaximumSessions);
                command.Parameters.AddWithValue("@MaximumConnections", MaximumConnections);
                command.Parameters.AddWithValue("@MaximumOutboundBbps", MaximumOutboundBbps);
                command.Parameters.AddWithValue("@IsDefault", IsDefault);

                if (ID > 0)
                {
                    command.Parameters.AddWithValue("@ID", ID);
                    command.CommandText = "UPDATE [VoiceHostConfiguration] SET Description = @Description, MaximumSessions = @MaximumSessions, MaximumConnections = @MaximumConnections, MaximumOutboundBbps = @MaximumOutboundBbps, IsDefault = @IsDefault where ID = @ID";
                    command.ExecuteNonQuery();
                }
                else
                {
                    command.CommandText = "INSERT INTO [VoiceHostConfiguration] (Description, MaximumSessions, MaximumConnections, MaximumOutboundBbps, IsDefault) OUTPUT INSERTED.ID VALUES(@Description, @MaximumSessions, @MaximumConnections, @MaximumOutboundBbps,@IsDefault)";
                    try
                    {
                        ID = (int)command.ExecuteScalar();
                    }
                    catch (Exception ex)
                    {
                        Logger.Error(ex, "Failed to save VoiceHostConfiguration!");
                        return false;                        
                    }

                }
            }


            CacheManager.Expire(GetCacheKey( ID));

            return true;
        }

        public static VoiceHostConfiguration[] GetAll()
        {
            var configs = new List<VoiceHostConfiguration>();
            using (var connection = DatabaseHelper.Instance.GetConnection())
            {
                using (var command = connection.CreateCommand())
                {
                    command.CommandText = "SELECT ID FROM [VoiceHostConfiguration]";

                    using (var reader = command.ExecuteReader())
                    {
                        while (reader.Read())
                        {
                            configs.Add(GetByID(reader.GetInt32(0)));
                        }                        
                    }
                }
            }
            return configs.ToArray();
        }

        public static string GetCacheKey(int id)
        {
            return "VoiceHostConfigurationByID:" + id;
        }

        public static VoiceHostConfiguration GetByID(int id)
        {
            return CacheManager.GetOrAdd(GetCacheKey(id), () => GetFromDatabaseByID(id));
        }
        
    }
}