﻿using Curse.Voice.Helpers;
using System;
using System.Collections.Concurrent;
using System.Data.SqlClient;

namespace Curse.Voice.Service.Models
{
    public class VoiceHostPayload
    {
        public int ID { get; set; }
        public int VersionID { get; set; }
        public byte[] Data { get; set; }

        public VoiceHostPayload()
        {

        }

        public VoiceHostPayload(SqlDataReader reader)
        {
            ID = (int)reader["ID"];
            VersionID = (int)reader["VersionID"];
            Data = (byte[])reader["Data"];
        }

        public void SaveToDatabase(SqlConnection conn, SqlTransaction transaction = null)
        {
            using (var command = conn.CreateCommand())
            {
                command.Transaction = transaction;
                command.Parameters.AddWithValue("@VersionID", VersionID);
                command.Parameters.AddWithValue("@Data", Data);

                if (ID > 0)
                {
                    throw new Exception("Cannot save existing payload!");
                }

                command.Parameters.AddWithValue("@DateCreated", DateTime.UtcNow);
                command.CommandText = "INSERT INTO [VoiceHostPayload] ([VersionID], [Data]) OUTPUT INSERTED.ID VALUES(@VersionID, @Data)";                
                ID = (int)command.ExecuteScalar();

            }
        }

        public void SaveToDatabase()
        {
            using (var connection = DatabaseHelper.Instance.GetConnection())
            {
                SaveToDatabase(connection);
            }
        }

        private static readonly ConcurrentDictionary<int, VoiceHostPayload> _payloadsByVersionID = new ConcurrentDictionary<int, VoiceHostPayload>();
       
        public static VoiceHostPayload GetByVersionID(int versionID)
        {
            VoiceHostPayload payload = null;

            if (_payloadsByVersionID.TryGetValue(versionID, out payload))
            {
                return payload;
            }

            using (var conn = DatabaseHelper.Instance.GetConnection())
            {
                using (var command = conn.CreateCommand())
                {
                    command.CommandText = "SELECT * FROM [VoiceHostPayload] WHERE [VersionID] = @VersionID";
                    command.Parameters.AddWithValue("@VersionID", versionID);

                    using (var reader = command.ExecuteReader())
                    {
                        if (reader.Read())
                        {
                            payload = new VoiceHostPayload(reader);
                            _payloadsByVersionID.TryAdd(payload.VersionID, payload);
                            return payload;

                        }
                    }
                }
            }

            return null;
        }

    }
}