﻿using System.Data.SqlClient;
using Curse.Voice.Helpers;

namespace Curse.Voice.Service.Models
{
    public class VoiceHostProviderRegion
    {
        public int ID { get; set; }
        public string DomainName { get; set; }
        public int RegionID { get; set; }

        public VoiceHostProviderRegion() { }

        public VoiceHostProviderRegion(SqlDataReader reader)
        {
            ID = reader.GetInt32(0);
            DomainName = reader.GetString(1);
            RegionID = reader.GetInt32(2);
        }

        public static VoiceHostProviderRegion GetByDomainName(string domainName)
        {
            using (var connection = DatabaseHelper.Instance.GetConnection())
            {
                using (var command = connection.CreateCommand())
                {
                    command.CommandText = "SELECT * FROM [VoiceHostProviderRegion] where DomainName = @DomainName";
                    command.Parameters.AddWithValue("DomainName", domainName);
                    using (var reader = command.ExecuteReader())
                    {
                        if (reader.Read())
                        {
                            return new VoiceHostProviderRegion(reader);
                        }

                        return null;

                    }
                }
            }
        }

        public static VoiceHostProviderRegion GetByIPRange(string ipAddressMask)
        {
            using (var connection = DatabaseHelper.Instance.GetConnection())
            {
                using (var command = connection.CreateCommand())
                {
                    command.CommandText = "SELECT * FROM [VoiceHostProviderRegion] where IPAddressMask = @IPAddressMask";
                    command.Parameters.AddWithValue("IPAddressMask", ipAddressMask);
                    using (var reader = command.ExecuteReader())
                    {
                        if (reader.Read())
                        {
                            return new VoiceHostProviderRegion(reader);
                        }

                        return null;

                    }
                }
            }
        }

    }
}