﻿using Curse.Voice.Helpers;
using System;
using System.Data.SqlClient;

namespace Curse.Voice.Service.Models
{
    public enum VoiceHostUpdateJobStatus
    {
        Pending = 1,
        Started,
        Cancelled,
        Failed,
        Completed,
    }

    public class VoiceHostUpdateJob
    {
        public int ID { get; set; }
        public DateTime DateCreated { get; set; }
        public DateTime DateModified { get; set; }
        public int VersionID { get; set; }

        public VoiceHostVersion Version
        {
            get { return VoiceHostVersion.GetByID(VersionID); }
        }

        public int TotalHosts { get; set; }
        public int CurrentProgress { get; set; }
        public VoiceHostUpdateJobStatus Status { get; set; }
        public int Successes { get; set; }
        public int Failures { get; set; }


        public VoiceHostUpdateJob()
        {
            
        }

        public VoiceHostUpdateJob(SqlDataReader reader)
        {
            ID = reader.GetInt32(0);
            DateCreated = reader.GetDateTime(1);
            DateModified = reader.GetDateTime(2);
            VersionID = reader.GetInt32(3);
            TotalHosts = reader.GetInt32(4);
            CurrentProgress = reader.GetInt32(5);
            Status = (VoiceHostUpdateJobStatus)reader.GetByte(6);
            Successes = reader.GetInt32(7);
            Failures = reader.GetInt32(8);
        }
      

        public static VoiceHostUpdateJob GetByID(int id)
        {
                      
            using (var connection = DatabaseHelper.Instance.GetConnection())
            {
                using (var command = connection.CreateCommand())
                {
                    command.CommandText = "SELECT * FROM [VoiceHostUpdateJob] WHERE ID = @ID";
                    command.Parameters.AddWithValue("@ID", id);

                    using (var reader = command.ExecuteReader())
                    {
                        if (reader.Read())
                        {
                            return new VoiceHostUpdateJob(reader);
                        }
                    }
                }
            }

            return null;
        }

        public void IncrementProgress()
        {
            using (var connection = DatabaseHelper.Instance.GetConnection())
            {
                using (var command = connection.CreateCommand())
                {
                    command.Parameters.AddWithValue("@ID", ID);
                    command.CommandText = "UPDATE [VoiceHostUpdateJob] SET CurrentProgress = CurrentProgress + 1, DateModified = GETUTCDATE() WHERE ID = @ID";
                    command.ExecuteNonQuery();
                }
            }
        }

        public void TrackSuccess()
        {
            using (var connection = DatabaseHelper.Instance.GetConnection())
            {
                using (var command = connection.CreateCommand())
                {
                    command.Parameters.AddWithValue("@ID", ID);
                    command.CommandText = "UPDATE [VoiceHostUpdateJob] SET Successes = Successes + 1, DateModified = GETUTCDATE() WHERE ID = @ID";
                    command.ExecuteNonQuery();
                }
            }
        }

        public void TrackFailure()
        {
            using (var connection = DatabaseHelper.Instance.GetConnection())
            {
                using (var command = connection.CreateCommand())
                {
                    command.Parameters.AddWithValue("@ID", ID);
                    command.CommandText = "UPDATE [VoiceHostUpdateJob] SET Failures = Failures + 1, DateModified = GETUTCDATE() WHERE ID = @ID";
                    command.ExecuteNonQuery();
                }
            }
        }

        public void ChangeStatus(VoiceHostUpdateJobStatus status)
        {
            using (var connection = DatabaseHelper.Instance.GetConnection())
            {
                using (var command = connection.CreateCommand())
                {
                    command.Parameters.AddWithValue("@ID", ID);
                    command.Parameters.AddWithValue("@Status", status);
                    command.CommandText = "UPDATE [VoiceHostUpdateJob] SET Status = @Status, DateModified = GETUTCDATE() WHERE ID = @ID";
                    command.ExecuteNonQuery();
                }
            }
        }


        public void SaveToDatabase(SqlConnection conn, SqlTransaction transaction = null)
        {
            using (var command = conn.CreateCommand())
            {
                command.Transaction = transaction;                
                command.Parameters.AddWithValue("@DateModified", DateTime.UtcNow);
                command.Parameters.AddWithValue("@CurrentProgress", CurrentProgress);
                command.Parameters.AddWithValue("@Status", (byte)Status);

                if (ID > 0)
                {
                    command.CommandText = "UPDATE [VoiceHostUpdateJob] SET DateModified = @DateModified, CurrentProgress = @CurrentProgress, Status = @Status WHERE ID = @ID";
                    command.Parameters.AddWithValue("@ID", ID);
                    command.ExecuteNonQuery();
                }
                else
                {
                    command.Parameters.AddWithValue("@VersionID", VersionID);
                    command.Parameters.AddWithValue("@TotalHosts", TotalHosts);
                    command.Parameters.AddWithValue("@DateCreated", DateTime.UtcNow);
                    command.CommandText = "INSERT INTO [VoiceHostUpdateJob] (VersionID, TotalHosts, Status) OUTPUT INSERTED.ID VALUES(@VersionID, @TotalHosts, @Status)";
                    ID = (int)command.ExecuteScalar();
                }
            }
        }
    }
}