﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using System.Linq;
using System.Web;
using Curse.Voice.Helpers;

namespace Curse.Voice.Service.Models
{
    public enum VoiceHostUpdateTargetStatus
    {
        Pending = 1,        
        TransferringPayload,        
        Failed,
        Successful
    }

    public class VoiceHostUpdateTarget
    {
        public int ID { get; set; }
        public int JobID { get; set; }
        public int HostID { get; set; }
        public VoiceHostUpdateTargetStatus Status { get; set; }

        public VoiceHostUpdateTarget()
        {

        }

        public VoiceHostUpdateTarget(SqlDataReader reader)
        {
            ID = reader.GetInt32(0);
            JobID = reader.GetInt32(1);
            HostID = reader.GetInt32(2);
            Status = (VoiceHostUpdateTargetStatus)reader.GetByte(3);
        }

        public void SaveToDatabase()
        {
            using (SqlConnection conn = DatabaseHelper.Instance.GetConnection())
            {
                SaveToDatabase(conn);
            }
        }

        public void SaveToDatabase(SqlConnection conn, SqlTransaction transaction = null)
        {
            using (SqlCommand command = conn.CreateCommand())
            {
                command.Transaction = transaction;

                command.Parameters.AddWithValue("@JobID", JobID);
                command.Parameters.AddWithValue("@DateModified", DateTime.UtcNow);
                command.Parameters.AddWithValue("@HostID", HostID);
                command.Parameters.AddWithValue("@Status", (byte)Status);

                if (ID > 0)
                {
                    command.CommandText = "UPDATE [VoiceHostUpdateTarget] SET Status = @Status WHERE ID = @ID";
                    command.Parameters.AddWithValue("@ID", ID);
                    command.ExecuteNonQuery();
                }
                else
                {
                    command.Parameters.AddWithValue("@DateCreated", DateTime.UtcNow);
                    command.CommandText = "INSERT INTO [VoiceHostUpdateTarget] (JobID, HostID, Status) OUTPUT INSERTED.ID VALUES(@JobID, @HostID, @Status)";
                    ID = (int)command.ExecuteScalar();                    
                }
            }
        }

        public void ChangeStatus(VoiceHostUpdateTargetStatus status)
        {
            using (SqlConnection connection = DatabaseHelper.Instance.GetConnection())
            {
                using (SqlCommand command = connection.CreateCommand())
                {
                    command.Parameters.AddWithValue("@ID", ID);
                    command.Parameters.AddWithValue("@Status", status);
                    command.CommandText = "UPDATE [VoiceHostUpdateTarget] SET Status = @Status WHERE ID = @ID";
                    command.ExecuteNonQuery();
                }
            }
        }

        public static VoiceHostUpdateTarget[] GetAllByJobID(int jobID)
        {
            List<VoiceHostUpdateTarget> voiceHosts = new List<VoiceHostUpdateTarget>();
            using (SqlConnection connection = DatabaseHelper.Instance.GetConnection())
            {
                using (SqlCommand command = connection.CreateCommand())
                {
                    command.CommandText = "SELECT * FROM [VoiceHostUpdateTarget] where JobID = @JobID";
                    command.Parameters.AddWithValue("@JobID", jobID);

                    using (SqlDataReader reader = command.ExecuteReader())
                    {
                        while (reader.Read())
                        {                                                     
                            voiceHosts.Add(new VoiceHostUpdateTarget(reader));
                        }
                    }
                }
            }

            return voiceHosts.ToArray();
        }
    }
}