﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.ServiceModel.Channels;
using System.ServiceModel.Configuration;
using System.ServiceModel.Description;
using System.ServiceModel.Dispatcher;
using System.Text;

namespace Curse.Voice.Service.ServiceModels
{
    [DataContract(Namespace = AuthToken.HeaderNamespace)]
    public sealed class AuthToken
    {
        public const string HeaderName = "AuthenticationContext";
        public const string HeaderNamespace = "urn:Curse.ClientService:v1";

        // These are the fields that will be serialized and passed through the header
        [DataMember]
        public string Username { get; set; }

        [DataMember]
        public string Password { get; set; }

        public bool IsAnonymous
        {
            get;
            set;
        }

        public AuthToken() { }

        public AuthToken(string username, string password)
        {
            Username = username;
            Password = password;
        }


        private static AuthToken _outgoing;

        // These are the values owned by the client's current
        // thread, that will be passed to the service.
        public static AuthToken Outgoing
        {
            get
            {
                return _outgoing;
            }
            set
            {
                _outgoing = value;
            }
        }
    }

    public sealed class AuthTokenExtension : BehaviorExtensionElement, IEndpointBehavior, IClientMessageInspector
    {
        public override Type BehaviorType
        {
            get { return GetType(); }
        }

        protected override object CreateBehavior()
        {
            return new AuthTokenExtension();
        }

        object IClientMessageInspector.BeforeSendRequest(ref Message request, IClientChannel channel)
        {
            MessageHeader messageHeader = MessageHeader.CreateHeader(AuthToken.HeaderName, AuthToken.HeaderNamespace, AuthToken.Outgoing);
            request.Headers.Add(messageHeader);
            return null;

        }

        void IEndpointBehavior.ApplyClientBehavior(ServiceEndpoint endpoint, ClientRuntime clientRuntime)
        {
            clientRuntime.MessageInspectors.Add(new AuthTokenExtension());
        }

        void IClientMessageInspector.AfterReceiveReply(ref Message reply, object correlationState)
        {
            // Do nothing
        }

        void IEndpointBehavior.AddBindingParameters(ServiceEndpoint endpoint, BindingParameterCollection bindingParameters)
        {
            // Do nothing
        }

        void IEndpointBehavior.ApplyDispatchBehavior(ServiceEndpoint endpoint, EndpointDispatcher endpointDispatcher)
        {
            // Do nothing
        }

        void IEndpointBehavior.Validate(ServiceEndpoint endpoint)
        {
            // Do nothing
        }
    }
}
