﻿using System.Runtime.Serialization;

namespace Curse.Voice.Service.ServiceModels
{

    public enum LogDataPayloadType
    {
        Legacy = 0,
        VoiceHost = 1,
        VoiceService = 2,
        FriendHost = 3,
        FriendService = 4,
        FriendWorker = 5,
        FriendsGroupService = 6,
        FriendsJobService = 7
    }

    [DataContract]
    public class LogDataPayload
    {
        [DataMember]
        public string ApiKey { get; set; }

        [DataMember]
        public string ExternalID { get; set; }

        [DataMember]
        public string HostName { get; set; }

        [DataMember]
        public string SerializedLogEntries
        {
            get;
            set;
        }

        [DataMember]
        public LogDataPayloadType Type
        {
            get;
            set;
        }

        [DataMember]
        public int TypeID
        {
            get;
            set;
        }   
    }

}