﻿using Curse.Voice.Service.Models;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.ServiceModel;
using System.Web;

namespace Curse.Voice.Service.ServiceModels
{
    [MessageContract]
    public class UpdatePayload : IDisposable
    {
        [MessageHeader(MustUnderstand = true)]
        public string ApiKey { get; set; }

        [MessageHeader(MustUnderstand = true)]
        public string ServerVersionString { get; set; }

        [MessageHeader(MustUnderstand = true)]
        public string MinimumClientVersionString { get; set; }

        [MessageHeader(MustUnderstand = true)]
        public VoiceHostEnvironment Environment { get; set; }

        [MessageHeader(MustUnderstand = true)]
        public bool DisableRollout { get; set; }

        [MessageHeader(MustUnderstand = true)]
        public int HostID { get; set; }

        [MessageHeader(MustUnderstand = true)]
        public int RegionID { get; set; }

        [MessageHeader(MustUnderstand = true)]
        public bool AbortOnFailure { get; set; }

        [MessageHeader(MustUnderstand = true)]
        public int HostModes { get; set; }

        [MessageBodyMember(Order = 1)]
        public Stream ZipFile
        {
            get; set; 
        }

        public void Dispose()
        {
            if (ZipFile != null)
            {
                ZipFile.Close();
                ZipFile = null;
            }
        } 
    }
}