﻿using System;
using System.Collections.Concurrent;
using System.Collections.Generic;
using System.Linq;
using System.Net.Mail;
using Curse.Logging;
using Curse.Voice.Helpers;

namespace Curse.Voice.Service.Utilities
{
    public static class NotificationHelper
    {
        private static ConcurrentDictionary<string, DateTime> _messageHistory = new ConcurrentDictionary<string, DateTime>(StringComparer.InvariantCultureIgnoreCase);
        private static TimeSpan _messageThrottle = TimeSpan.FromHours(1);

        public static void SendMessage(string messageKey, string messageSubject, string messageBody)
        {
            DateTime lastMessage;

            if (_messageHistory.TryGetValue(messageKey, out lastMessage))
            {
                if (DateTime.UtcNow - lastMessage < _messageThrottle)
                {
                    return;
                }
            }

            try
            {
                _messageHistory.AddOrUpdate(messageKey, DateTime.UtcNow, (key, val) => DateTime.UtcNow);
            }
            catch { }

            string subjectPrefix = "";

#if DEBUG
            subjectPrefix = "[TESTING] ";
#endif

            try
            {
                MailMessage mailMessage = new MailMessage("\"CurseVoice Server Notifications\" <noreply@curse.com>", "mcomperda@curse.com", subjectPrefix + messageSubject, messageBody);
                SmtpClient mailClient = new SmtpClient("smtp01-live.curse.us");
                mailClient.Send(mailMessage);
            }
            catch (Exception ex)
            {
                Logger.Error(ex, "Failed to send email!");
            }

        }
    }
}