﻿using System;
using System.Collections.Concurrent;
using System.ServiceModel;
using Curse.Logging;
using Curse.Voice.Service.Extensions;

namespace Curse.Voice.Service
{
    public static class VoiceBanManager
    {
        private readonly static ConcurrentDictionary<int, DateTime> BannedUsers = new ConcurrentDictionary<int, DateTime>();

        public static bool IsBanned(int userID)
        {
            DateTime banDate;
            if (BannedUsers.TryGetValue(userID, out banDate))
            {
                if (DateTime.UtcNow - banDate < TimeSpan.FromMinutes(CoreServiceConfiguration.Instance.BanDurationMinutes))
                {
                    return true;
                }
                BannedUsers.TryRemove(userID, out banDate);
            }

            return false;
        }

        public static void Ban(int userID, bool logBan, object logData)
        {
            if (!BannedUsers.ContainsKey(userID))
            {
                BannedUsers.TryAdd(userID, DateTime.UtcNow);
                Logger.Info("User (ID:" + userID + "  has attempted to join an invalid session too many times, and is now banned.", logData);
            }
            else if (logBan)
            {
                Logger.Info("Banned User (ID:" + userID + ") has continued to try brute force a session after being banned.", logData);
            }
        }

        public static void BanForSpamming(int userID)
        {
            if (BannedUsers.ContainsKey(userID))
            {
                return;
            }

            BannedUsers.TryAdd(userID, DateTime.UtcNow);                
            Logger.Info("User (ID:" + userID + ", IP: " + OperationContext.Current.GetClientIPAddress() + ") has been banned for creating too many sessions.");
        }
    }
}