﻿using Curse.Logging;
using Curse.Voice.Helpers;
using Curse.Voice.HostManagement;
using System;
using System.ServiceModel;
using Curse.Voice.Contracts;
using Curse.Voice.Service.Models;

namespace Curse.Voice.Service
{
    [CallbackBehavior(ConcurrencyMode = ConcurrencyMode.Reentrant, UseSynchronizationContext = false)]
    public class VoiceHostCallbackClient : IVoiceHostCallbackClient
    {
        private readonly int _hostID;
        
        public VoiceHostCallbackClient(int hostID)
        {
            _hostID = hostID;
        }

        public void ReceiveInstanceDestroyed(string instanceIdentifier)
        {
            try
            {
                var voiceInstance = VoiceInstance.GetByCode(instanceIdentifier);

                if (voiceInstance == null || voiceInstance.Status == VoiceInstanceStatus.Shutdown)
                {
                    return;
                }

                if (voiceInstance.VoiceHostID != _hostID)
                {
                    Logger.Debug("Supressing instance destroyed calledback. It originated from a different host than the one currently hosting it.", new
                    {
                        CallbackHostID = _hostID,
                        CurrentHostID = voiceInstance.VoiceHostID,
                        voiceInstance.Code,
                        voiceInstance.Mode,
                        voiceInstance.Type
                    });
                    return;   
                }
                
                voiceInstance.Status = VoiceInstanceStatus.Shutdown;
                voiceInstance.DateEnded = DateTime.UtcNow;
                voiceInstance.Save();            
            }
            catch (Exception ex)
            {
                Logger.Error(ex, "ReceiveInstanceDestroyed Failed");
            }
            
        }
    }
}