﻿using System;
using System.ServiceModel;
using Curse.Voice.Service.Requests;
using Curse.Voice.Service.Responses;

namespace Curse.Voice.Service
{
    [ServiceBehavior(AddressFilterMode = AddressFilterMode.Any, ConcurrencyMode = ConcurrencyMode.Multiple, UseSynchronizationContext = false, InstanceContextMode = InstanceContextMode.PerCall)]
    public class VoiceService : IVoiceService
    {
        public GetVoiceSessionResponse GetVoiceSession(GetVoiceSessionRequest request)
        {

            Version version;
            if (!Version.TryParse(request.ClientVersion, out version))
            {
                return new GetVoiceSessionResponse { Status = GetVoiceSessionStatus.IncompatibleClient };
            }

            return VoiceSessionManager.GetVoiceSession(request.InviteCode, version);
        }
    }
}
