﻿using System;
using System.Text;
using Curse.Hashing;

namespace Curse.Voice.Helpers
{
    public static class AccessTokenHelper
    {
        private static long _privateSeed = 1234;

        public static void Initialize(long seed)
        {
            _privateSeed = seed;
        }

        public static long CreateAccessToken(string instanceGuid, int userID)
        {
            return DoCreateAccessToken(DateTime.UtcNow, TimeSpan.Zero, instanceGuid, userID);
        }

        public static bool CheckAccessToken(long token, string instanceGuid, int userID)
        {
            return DoCheckAccessToken(token, instanceGuid, userID);
        }
       
        private static bool DoCheckAccessToken(long token, params object[] keyValues)
        {
            // Check against the previous, current, and next 5-minute intervals to handle edge cases and clock skew
            var timestamp = DateTime.UtcNow;
            return token == DoCreateAccessToken(timestamp, TimeSpan.FromMinutes(-5), keyValues) ||
                   token == DoCreateAccessToken(timestamp, TimeSpan.Zero, keyValues) ||
                   token == DoCreateAccessToken(timestamp, TimeSpan.FromMinutes(5), keyValues);
        }

        private static long DoCreateAccessToken(DateTime timestamp, TimeSpan offset, params object[] keyValues)
        {            
            // Round down to the nearest 5 minutes and subtract the specified offset.
            var accessTimestamp = new DateTime(timestamp.Year, timestamp.Month, timestamp.Day, timestamp.Hour, timestamp.Minute - timestamp.Minute % 5, 0,
                DateTimeKind.Utc) + offset;

            var sb = new StringBuilder().Append(_privateSeed).Append(accessTimestamp);

            foreach (var keyValue in keyValues)
            {
                sb.Append(keyValue);
            }

            return MurmurHash2.ComputeHash(sb.ToString());
        }
    }
}
