﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.ServiceModel;
using System.ServiceModel.Channels;
using System.Text;

namespace Curse.Voice.Helpers
{
    public static class BindingHelper
    {
        public  static BasicHttpBinding GetBasicHttpBinding(int sendTimeoutSeconds = 10)
        {
            var binding = new BasicHttpBinding()
                {
                    OpenTimeout = TimeSpan.FromSeconds(5),
                    SendTimeout = TimeSpan.FromSeconds(sendTimeoutSeconds),
                    ReceiveTimeout = TimeSpan.FromSeconds(10),                     
                    
                };

            return binding;
        }

        public static WSDualHttpBinding GetWsDualHttpBinding(int sendTimeoutSeconds = 10)
        {
            var binding = new WSDualHttpBinding()
            {
                OpenTimeout = TimeSpan.FromSeconds(5),
                SendTimeout = TimeSpan.FromSeconds(sendTimeoutSeconds),
                ReceiveTimeout = TimeSpan.FromSeconds(10),

            };

            return binding;
        }

        public static WSHttpBinding GetWsHttpBinding(int sendTimeoutSeconds = 10)
        {
            return new WSHttpBinding
            {
                OpenTimeout = TimeSpan.FromSeconds(5),
                SendTimeout = TimeSpan.FromSeconds(sendTimeoutSeconds),
                ReceiveTimeout = TimeSpan.FromSeconds(10),
            };
        }

        public static CustomBinding GetCustomBinaryHttpBinding()
        {
            var binding = new CustomBinding();

            binding.CloseTimeout = TimeSpan.FromSeconds(10);
            binding.OpenTimeout = TimeSpan.FromSeconds(10);
            binding.ReceiveTimeout = TimeSpan.FromMinutes(1);
            binding.SendTimeout = TimeSpan.FromMinutes(1);

            // Binary Encoding
            var binaryEncoding = new BinaryMessageEncodingBindingElement();
            binaryEncoding.ReaderQuotas.MaxArrayLength = 16384;
            binaryEncoding.ReaderQuotas.MaxBytesPerRead = 4096;
            binaryEncoding.ReaderQuotas.MaxNameTableCharCount = 16384;
            binaryEncoding.ReaderQuotas.MaxDepth = 64;
            binaryEncoding.ReaderQuotas.MaxStringContentLength = 640000;
            binding.Elements.Add(binaryEncoding);

            // Http Transport
            var httpTransport = new HttpTransportBindingElement();
            httpTransport.AuthenticationScheme = AuthenticationSchemes.Anonymous;
            httpTransport.MaxBufferPoolSize = 524288;
            httpTransport.MaxReceivedMessageSize = 2147483647;
            httpTransport.MaxBufferSize = 2147483647;
            httpTransport.AllowCookies = false;
            httpTransport.HostNameComparisonMode = HostNameComparisonMode.StrongWildcard;
            httpTransport.TransferMode = TransferMode.Buffered;
            httpTransport.AllowCookies = true;
            binding.Elements.Add(httpTransport);

            return binding;
        }
    }
}
