﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using System.Linq;
using System.Web;
using Curse.Logging;

namespace Curse.Voice.Helpers
{
    public class DatabaseHelper
    {
        public static readonly DatabaseHelper Instance = new DatabaseHelper();
        private string _connectionString = null;

        public void Initialize(string connectionString)
        {
            _connectionString = connectionString;
        }

        public SqlConnection GetConnection(string connectionString = null)
        {
            connectionString = connectionString ?? _connectionString;

            var connection = new SqlConnection(connectionString);
            try
            {
                connection.Open();
                using (var cmd = connection.CreateCommand())
                {
                    cmd.CommandText = "SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;";
                    cmd.ExecuteNonQuery();     
                }                           
            }
            catch (Exception ex)
            {
                Logger.Error(ex, "Failed to connect to SQL Server", new { ConnectionString = connectionString });
                throw;
            }
            return connection;
        }

    }
}