﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;

namespace Curse.Voice.Helpers
{
    public static class MachineKeyHelper
    {

        private static FileInfo GetKeyFileInfo()
        {
            var installDirectory = FindInstallPath();            
            return new FileInfo(Path.Combine(installDirectory.FullName, "CurseVoice.key"));
        }

        private static FileInfo GetModeFileInfo()
        {
            var installDirectory = FindInstallPath();
            return new FileInfo(Path.Combine(installDirectory.FullName, "CurseVoiceMode.txt"));
        }

        private static DirectoryInfo FindInstallPath()
        {
            var installDirectory = new DirectoryInfo(@"c:\Program Files\CurseVoice\");

            if (installDirectory != null && installDirectory.Exists)
            {
                return installDirectory;
            }

            installDirectory = new DirectoryInfo(@"c:\Program Files\Curse\CurseVoice\");

            if (installDirectory != null && installDirectory.Exists)
            {
                return installDirectory;
            }


            throw new Exception("Unable to get current directory!");
        }

        public static Guid GetMachineKey()
        {
#if CONFIG_DEBUG
            return new Guid("fb0fdd94-61b9-4f14-aed2-d5e72612bf19");
#endif
            // Get or create a file, storing a Guid
            var keyFile = GetKeyFileInfo();

            if (!keyFile.Exists)
            {
                return GenerateMachineKey();
            }

            string machineIDString = null;
            using (var reader = new StreamReader(keyFile.FullName))
            {
                machineIDString = reader.ReadLine();
            }

            Guid machineID;
            if (!Guid.TryParse(machineIDString, out machineID))
            {
                return GenerateMachineKey();
            }

            return machineID;

        }

        private const int DefaultMode = 1;
        private const int DefaultDebugMode = 3;

        public static int GetMode()
        {
#if CONFIG_DEBUG
            return DefaultDebugMode;
#endif
            // Get or create a file, storing a Guid
            var keyFile = GetModeFileInfo();

            if (!keyFile.Exists)
            {
                return DefaultMode;
            }

            string modeString = null;
            using (var reader = new StreamReader(keyFile.FullName))
            {
                modeString = reader.ReadLine();
            }

            int mode;
            return !int.TryParse(modeString, out mode) ? DefaultMode : mode;
        }

        private static Guid GenerateMachineKey()
        {
            var keyFile = GetKeyFileInfo();
            Guid machineID = Guid.NewGuid();
            using (StreamWriter writer = new StreamWriter(keyFile.FullName, false))
            {
                writer.WriteLine(machineID);
            }            
            return machineID;
        }
    }
}
