﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Curse.Voice.Host.Extensions
{
    public static class TaskHelper
    {
        public static bool WaitAllSafely(IEnumerable<Task> tasks, TimeSpan timeout)
        {
            try
            {               
                return Task.WaitAll(tasks.ToArray(), (int)timeout.TotalMilliseconds);
            }
            catch (Exception ex)
            {
                Debug.WriteLine(ex.Message);
                return false;
            }
        }
    }
}
