﻿using Curse.Voice.HostInterface;
using Curse.Voice.HostInterface.Models;
using Curse.Voice.HostInterface.Responses;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.ServiceModel;
using System.Text;
using System.Threading.Tasks;

namespace Curse.Voice.Host
{

    [ServiceBehavior(AddressFilterMode = AddressFilterMode.Any, ConcurrencyMode = ConcurrencyMode.Multiple, InstanceContextMode = InstanceContextMode.Single, UseSynchronizationContext = false)]
    public class VoiceHost : ICurseVoiceHost
    {
        public VoiceHost()
        {

        }

        public VoiceHost(VoiceInstance voiceInstance)
        {
            VoiceInstance = voiceInstance;
        }

        public VoiceInstance VoiceInstance { get; set; }

        public IEnumerable<VoiceUser> GetUsers()
        {
            return VoiceInstance.Users;
        }


        public VoiceSession CurrentSession
        {
            get
            {
                ICurseVoiceCallbackClient callbackClient = OperationContext.Current.GetCallbackChannel<ICurseVoiceCallbackClient>();
                if (callbackClient == null)
                {
                    return null;
                }
                return VoiceInstance.GetSession(callbackClient.GetHashCode());
            }
        }

        public void Leave()
        {
            VoiceSession session = CurrentSession;
            if (session != null)
            {
                VoiceInstance.ClientDisconnected(session);
            }
        }

        public JoinResponse Join(string displayName, string avatarUrl, int? userID)
        {
            if (VoiceInstance.Users.Any(p => p.DisplayName.Equals(displayName, StringComparison.InvariantCultureIgnoreCase)))
            {
                try
                {

                }
                catch (Exception)
                {

                    throw;
                }
                return new JoinResponse(JoinResponseStatus.FailedNameAlreadyTaken);
            }

            try
            {
                ICurseVoiceCallbackClient callbackClient = OperationContext.Current.GetCallbackChannel<ICurseVoiceCallbackClient>();
                VoiceInstance.CreateSession(userID, displayName, avatarUrl, callbackClient);
            }
            catch (Exception ex)
            {
                return new JoinResponse(JoinResponseStatus.FailedUnhandledException);
            }

            return new JoinResponse(JoinResponseStatus.Successful, VoiceInstance.Users);
        }

        public void Transmit(byte[] voiceData, bool loopback = false)
        {
  
            VoiceSession session = CurrentSession;

            if (session == null)
            {
                return;
            }

            if (voiceData.Length > 1024)
            {
                return;
            }

            VoiceInstance.BroadcastTransmit(session, voiceData, loopback);
        }

        public void EndTransmit()
        {
            VoiceSession session = CurrentSession;

            if (session == null)
            {
                return;
            }

            VoiceInstance.BroadcastEndTransmit(session.User.ID);
        }

        public void UpdateUser(string displayName, string avatarUrl)
        {
            VoiceSession session = CurrentSession;

            if (session == null)
            {
                return;
            }

            if (displayName != null)
            {
                session.User.DisplayName = displayName;
            }
            if (avatarUrl != null)
            {
                session.User.AvatarUrl = avatarUrl;
            }

            VoiceInstance.BroadcastUserUpdate(session.User);
        }

        public void SendChatMessage(string body)
        {
            VoiceSession session = CurrentSession;

            if (session == null || body.Length > 1024)
            {
                return;
            }


            VoiceInstance.BroadcastChatMessage(new ChatMessage() { AuthorUserID = session.User.ID, Body = body });
        }

    }
}
