﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.ServiceModel;
using System.ServiceModel.Description;
using System.Text;
using System.Threading.Tasks;
using Curse.Voice.HostInterface;
using Curse.Voice.HostInterface.Models;
using System.Threading;

namespace Curse.Voice.HostInterface
{
    [CallbackBehavior(ConcurrencyMode = ConcurrencyMode.Reentrant, UseSynchronizationContext = false)]
    public class CurseVoiceCallbackClient : ICurseVoiceCallbackClient
    {

        public event EventHandler<EventArgs<VoiceTransmission>> OnTransmission;
        public event EventHandler<EventArgs<VoiceUser>> OnUserJoined;
        public event EventHandler<EventArgs<int>> OnUserLeft;
        public event EventHandler<EventArgs<int>> OnEndTransmission;
        public event EventHandler<EventArgs<VoiceUser>> OnUserUpdate;
        public event EventHandler<EventArgs<ChatMessage>> OnReceiveChatMessage;

        public Task ReceiveUserJoinedAsync(VoiceUser voiceUser)
        {
            if (OnUserJoined != null)
            {
                OnUserJoined.BeginInvoke(this, new EventArgs<VoiceUser>(voiceUser), null, null);
            }            
            return Task.Delay(0);
        }

        public Task ReceiveUserLeftAsync(int userID)
        {
            if (OnUserLeft != null)
            {
                OnUserLeft.BeginInvoke(this, new EventArgs<int>(userID), null, null);
            }
            return Task.Delay(0);
        }

        public Task ReceiveTransmission(VoiceTransmission transmission)
        {            
            if (OnTransmission != null)
            {
                OnTransmission.BeginInvoke(this, new EventArgs<VoiceTransmission>(transmission), null, null);
            }
            return Task.Delay(0);
        }

        public void ReceiveTransmissionSync(VoiceTransmission transmission)
        {
            if (OnTransmission != null)
            {
                OnTransmission.BeginInvoke(this, new EventArgs<VoiceTransmission>(transmission), null, null);
            }            
        }

        public Task ReceiveEndTransmission(int userID)
        {
            if (OnEndTransmission != null)
            {
                OnEndTransmission.BeginInvoke(this, new EventArgs<int>(userID), null, null);
            }
            return Task.Delay(0);
        }

        public Task ReceiveUserUpdate(VoiceUser user)
        {
            if (OnUserUpdate != null)
            {
                OnUserUpdate.BeginInvoke(this, new EventArgs<VoiceUser>(user), null, null);
            }
            return Task.Delay(0);
        }

        public Task ReceiveChatMessage(ChatMessage message)
        {
            
            if (OnReceiveChatMessage != null)
            {
                OnReceiveChatMessage.BeginInvoke(this, new EventArgs<ChatMessage>(message), null, null);
            }

            return Task.Delay(0);           
        }       
       
      
    }
}
