﻿using Curse.Voice.HostInterface;
using System;
using System.Collections.Generic;
using System.Linq;
using System.ServiceModel;
using System.ServiceModel.Description;
using System.Text;
using System.Threading.Tasks;
using Curse.Voice.HostInterface.Responses;
using Curse.Voice.HostInterface.Models;

namespace Curse.Voice.HostInterface
{
    public class CurseVoiceClient : DuplexClientBase<ICurseVoiceHost>, ICurseVoiceHost
    {
        public CurseVoiceCallbackClient CallbackClient { get; private set; }

        public event EventHandler<EventArgs> Closed;
        public event EventHandler<EventArgs> Faulted;

        public CurseVoiceClient(CurseVoiceCallbackClient callbackClient, ServiceEndpoint endpoint)
            : base(new InstanceContext(callbackClient), endpoint)
        {
            CallbackClient = callbackClient;
            (this as ICommunicationObject).Faulted += ChannelFactory_Faulted;
            (this as ICommunicationObject).Closed += ChannelFactory_Faulted;
        }

        private void EnsureConnectivity()
        {
            if (State != CommunicationState.Opened && State != CommunicationState.Opening)
            {
                throw new Exception("Connection state is not open or opening. The state is: " + State.ToString());
            }
        }

        private void ServiceClient_Closed(object sender, EventArgs e)
        {
            Console.WriteLine("Connection fauled or closed!");
            if (this.Closed != null)
            {
                this.Closed(this, e);
            }
        }
        private void ServiceClient_Faulted(object sender, EventArgs e)
        {
            if (this.Faulted != null)
            {
                this.Faulted(this, e);
            }
        }

        public void Leave()
        {
            EnsureConnectivity();
            try
            {
                Channel.Leave();
            }
            catch (Exception)
            {

                try
                {
                    Close();
                }
                catch (Exception)
                {
                                        
                }
                
            }
            
        }

        public JoinResponse Join(string displayName, string avatarUrl, int? userID)
        {
            return Channel.Join(displayName, avatarUrl, userID);
        }

        public void Transmit(byte[] voiceData, bool loopback = false)
        {
            EnsureConnectivity();
            Channel.Transmit(voiceData, loopback);
        }

        public void EndTransmit()
        {
            EnsureConnectivity();
            Channel.EndTransmit();
        }

        public IEnumerable<VoiceUser> GetUsers()
        {
            EnsureConnectivity();
            return Channel.GetUsers();
        }

        public void UpdateUser(string displayName, string avatarUrl)
        {
            EnsureConnectivity();
            Channel.UpdateUser(displayName, avatarUrl);
        }

        public void SendChatMessage(string message)
        {
            EnsureConnectivity();
            Channel.SendChatMessage(message);
        }

        void ChannelFactory_Faulted(object sender, EventArgs e)
        {
            Console.WriteLine("Connection faulted or closed!");
        }

    }
}
