﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.ServiceModel;
using System.Text;
using System.Threading.Tasks;
using Curse.Voice.HostInterface.Models;

namespace Curse.Voice.HostInterface
{
    public interface ICurseVoiceCallbackClient
    {        
        [OperationContract(IsOneWay = true)]
        Task ReceiveUserJoinedAsync(VoiceUser user);

        [OperationContract(IsOneWay = true)]
        Task ReceiveUserLeftAsync(int id);          

        [OperationContract(IsOneWay = true)]
        Task ReceiveTransmission(VoiceTransmission transmission);

        [OperationContract(IsOneWay = true)]
        void ReceiveTransmissionSync(VoiceTransmission transmission);

        [OperationContract(IsOneWay = true)]
        Task ReceiveEndTransmission(int id);

        [OperationContract(IsOneWay = true)]
        Task ReceiveUserUpdate(VoiceUser user);

        [OperationContract(IsOneWay = true)]
        Task ReceiveChatMessage(ChatMessage message);  

    }
}
