﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.Text;
using Curse.Voice.HostInterface.Responses;
using Curse.Voice.HostInterface.Models;

namespace Curse.Voice.HostInterface
{
    
    [ServiceContract(CallbackContract = typeof(ICurseVoiceCallbackClient), SessionMode = SessionMode.Required)]
    public interface ICurseVoiceHost
    {        
        [OperationContract(IsInitiating = true)]
        JoinResponse Join(string displayName, string avatarUrl, int? userID);

        [OperationContract(IsTerminating = true, IsOneWay = true)]
        void Leave();

        [OperationContract]
        IEnumerable<VoiceUser> GetUsers();

        [OperationContract(IsOneWay = true)]
        void Transmit(byte[] voiceData, bool loopback = false);

        [OperationContract(IsOneWay = true)]
        void EndTransmit();

        [OperationContract(IsOneWay = true)]
        void UpdateUser(string displayName, string avatarUrl);

        [OperationContract(IsOneWay = true)]
        void SendChatMessage(string message);
    }
    
}
