﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.Text;
using System.Threading.Tasks;

namespace Curse.Voice.HostInterface.Models
{
    [DataContract]
    public class VoiceUser : BaseModel
    {        
        private string _displayName;
        private string _avatarUrl;
        private bool _isTalking;
        private bool _isMuted;
        private float _volume;

        [DataMember]
        public int ID { get; private set; }

        [DataMember]
        public int? UserID { get; private set; }        

        [DataMember]
        public string DisplayName
        {
            get { return _displayName; }
            set { SetField(ref _displayName, value, "DisplayName"); }
        }

        [DataMember]
        public string AvatarUrl
        {
            get { return _avatarUrl; }
            set { SetField(ref _avatarUrl, value, "AvatarUrl"); }
        }

        [DataMember]
        public bool IsTalking
        {
            get { return _isTalking; }
            set { SetField(ref _isTalking, value, "IsTalking"); }
        }

        [DataMember]
        public bool IsMuted
        {
            get { return _isMuted; }
            set { SetField(ref _isMuted, value, "IsMuted"); }
        }

        [IgnoreDataMember]
        public float Volume
        {
            get { return _volume; }
            set { SetField(ref _volume, value, "Volume"); }
        }

        public VoiceUser()
        {

        }

        public VoiceUser(int id, int? userID, string displayName, string avatarUrl)
        {
            ID = id;
            UserID = userID;
            _displayName = displayName;
            _avatarUrl = avatarUrl;            
        }



       
    }
}
