﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net.Security;
using System.ServiceModel;
using System.Text;
using System.Threading.Tasks;
using System.ServiceModel.Description;

namespace Curse.Voice.HostInterface
{
    public static class TcpBindingHelper
    {
        public static NetTcpBinding GetServerTcpBinding()
        {
            NetTcpBinding binding = new NetTcpBinding(SecurityMode.None);
            binding.MaxConnections = Int32.MaxValue;
            binding.PortSharingEnabled = false;
            binding.MaxReceivedMessageSize = Int32.MaxValue;
            binding.ReaderQuotas.MaxArrayLength = Int32.MaxValue;
            binding.TransactionFlow = false;
            binding.ListenBacklog = 1000;
            binding.Security.Message.ClientCredentialType = MessageCredentialType.None;
            binding.Security.Transport.ClientCredentialType = TcpClientCredentialType.None;
            binding.Security.Transport.ProtectionLevel = ProtectionLevel.None;

            binding.ReceiveTimeout = TimeSpan.FromDays(1);
            binding.SendTimeout = TimeSpan.FromDays(1);

            return binding;
        }

        public static NetTcpBinding GetClientTcpBinding()
        {
            NetTcpBinding binding = new NetTcpBinding(SecurityMode.None);
            binding.MaxReceivedMessageSize = Int32.MaxValue;
            binding.TransactionFlow = false;
            binding.Security.Message.ClientCredentialType = MessageCredentialType.None;
            binding.Security.Transport.ClientCredentialType = TcpClientCredentialType.None;
            binding.Security.Transport.ProtectionLevel = ProtectionLevel.None;
            binding.OpenTimeout = TimeSpan.FromSeconds(5);
            binding.CloseTimeout = TimeSpan.FromSeconds(5);
            binding.ReceiveTimeout = TimeSpan.FromMinutes(5);
            binding.SendTimeout = TimeSpan.FromMinutes(1);
            return binding;
        }

        public static ServiceHost CreateServiceHost<T>(object serviceInstance, string address)
        {
            // Tcp Binding
            NetTcpBinding binding = GetServerTcpBinding();

            ServiceHost host = new ServiceHost(serviceInstance);

            // Service Throttling
            {
                ServiceThrottlingBehavior stb = new ServiceThrottlingBehavior();
                host.Description.Behaviors.Remove<ServiceThrottlingBehavior>();
                stb.MaxConcurrentCalls = Int32.MaxValue;
                stb.MaxConcurrentInstances = Int32.MaxValue;
                stb.MaxConcurrentSessions = Int32.MaxValue;
                host.Description.Behaviors.Add(stb);
            }

            // Service Meta Data
            {
                ServiceMetadataBehavior serviceMetadataBehavior = new ServiceMetadataBehavior();
                serviceMetadataBehavior.HttpGetEnabled = false;
                host.Description.Behaviors.Remove<ServiceMetadataBehavior>();
                host.Description.Behaviors.Add(serviceMetadataBehavior);
            }

            {
                ServiceDebugBehavior serviceDebugBehavior = new ServiceDebugBehavior();
                serviceDebugBehavior.IncludeExceptionDetailInFaults = true;
                host.Description.Behaviors.Remove<ServiceDebugBehavior>();
                host.Description.Behaviors.Add(serviceDebugBehavior);
            }

            host.AddServiceEndpoint(typeof(T), binding, address);

            return host;
        }
    }
}
