﻿using System;
using System.Net;
using System.Net.Sockets;
using System.ServiceModel;
using System.ServiceModel.Channels;
using System.ServiceModel.Web;

namespace Curse.Voice.HostManagement.Extensions
{
    public static class IPAddressExtensions
    {
        /// <summary>
        /// Returns the numeric representation of an IPAddress
        /// </summary>        
        public static Int64 ToInt64(this IPAddress value)
        {

            byte[] ipBytes = value.GetAddressBytes();
            Int64 ip = 0;
            for (int i = 0; i < ipBytes.Length; i++)
            {
                ip <<= 8;
                ip += ipBytes[i];
            }
            return ip;
        }

        public static IPAddress GetClientIPAddress(this OperationContext context, bool silentFailure = true)
        {            
            var prop = context.IncomingMessageProperties;
            var endpoint = prop[RemoteEndpointMessageProperty.Name] as RemoteEndpointMessageProperty;
            
            string ipAddress = endpoint != null ? endpoint.Address : null;
            return GetClientIPAddress(ipAddress ?? string.Empty, silentFailure);            
        }

        private static IPAddress GetClientIPAddress(string ipString, bool silentFailure = true)
        {
            if (ipString.Contains(","))
            {
                string[] ipArray = ipString.Split(',');
                ipString = ipArray[ipArray.Length - 1].Trim();
            }

            IPAddress ipAddress;
            if (IPAddress.TryParse(ipString, out ipAddress))
            {
                var family = ipAddress.AddressFamily;
                if (family == AddressFamily.InterNetwork || family == AddressFamily.InterNetworkV6)
                {
                    byte[] bytes = ipAddress.GetAddressBytes();
                    if (bytes.Length > 0)
                    {
                        return ipAddress;
                    }
                }
            }
            
            if (silentFailure)
            {
                return IPAddress.None;
            }

            throw new InvalidOperationException(string.Format("Cannot parse IPAddress '{0}'", ipString));
        }
    }
}