﻿using Curse.Voice.Contracts;
using Curse.Voice.HostManagement.Models;
using Curse.Voice.HostManagement.Responses;
using System;
using System.ServiceModel;

namespace Curse.Voice.HostManagement
{

    [ServiceContract(CallbackContract = typeof(IVoiceHostCallbackClient))]
    public interface IVoiceHostManagement
    {        
        [OperationContract]
        ProvisionInstanceResponse ProvisionGroupVoiceInstance(string instanceIdentifier, Guid groupID, string joinCode, string apiKey);
       
        [OperationContract]
        ProvisionInstanceResponse ProvisionTypedVoiceInstance(string instanceIdentifier, int ownerUserID, VoiceInstanceType type, string apiKey);

        [OperationContract]
        ProvisionInstanceResponse ProvisionGroupVoiceInstanceV2(string apiKey, string instanceIdentifier, Guid groupID, string joinCode, VoiceInstanceMode mode);        

        [OperationContract]
        ProvisionInstanceResponse ProvisionTypedVoiceInstanceV2(string apiKey, string instanceIdentifier, int ownerUserID, VoiceInstanceType type, VoiceInstanceMode mode);

        [OperationContract]
        UnlockInstanceResponse UnlockVoiceInstance(string instanceIdentifier, string apiKey);

        [OperationContract]
        KickUsersResponse KickUsers(string instanceIdentifier, int kickerUserID, int[] userIDsToKick, string apiKey);

        [OperationContract]
        RemoveUsersResponse RemoveUsers(string instanceIdentifier, int requestorUserID, int[] userIDsToRemove, UserDisconnectReason reason, string apiKey);

        [OperationContract]
        AddPendingUsersResponse AddPendingUsers(string instanceIdentifier, PendingUserRequest[] pendingUsers, string apiKey);

        [OperationContract]
        RemovePendingUserResponse RemovePendingUser(string instanceIdentifier, int curseUserID, string apiKey);

        [OperationContract]
        InstanceDetailsResponse GetInstanceDetails(string apiKey, Guid instanceIdentifier);

        [OperationContract]
        DestoryInstanceResponse DestroyVoiceInstance(string instanceIdentifier, string apiKey);

        [OperationContract]
        StatisticsResponse GetStatistics(string apiKey);

        [OperationContract]
        InstanceStatisticsResponse GetInstanceStatistics(string apiKey);

        [OperationContract]
        ConnectionDiagnosticsResponse GetConnectionDiagnostics(string apiKey);

        [OperationContract]
        FailoverServerResponse Failover(string apiKey, FailoverInstructions[] failovers);

        [OperationContract]
        FailoverServerResponse FailoverInstance(string apiKey, FailoverInstructions failover);

        [OperationContract]
        UpdateUserPermissionsResponse UpdateUserPermissions(string instanceIdentifier, VoiceUserPermissions[] userPermissions, string apiKey);

        [OperationContract]
        MuteUserResponse MuteUser(string instanceIdentifier, int requestorUserID, int mutedUserID, bool mute, string apiKey);

        [OperationContract]
        DeafenUserResponse DeafenUser(string instanceIdentifier, int requestorUserID, int deafenedUserID, bool deafen, string apiKey);

        [OperationContract]
        bool UpdateConfiguration(string apiKey, VoiceHostConfigurationContract configuration);
    }
}
