﻿using System;
using Curse.Voice.Helpers;
using Curse.Voice.HostManagement.Models;
using Curse.Voice.HostManagement.Responses;
using System.ServiceModel;
using Curse.Voice.Contracts;


namespace Curse.Voice.HostManagement
{
    public class VoiceManagementClient : DuplexClientBase<IVoiceHostManagement>, IVoiceHostManagement
    {        
        public VoiceManagementClient(InstanceContext callbackInstance, string address, int portNumber)
            : base(callbackInstance, TcpBindingHelper.GetClientTcpBinding(), new EndpointAddress(string.Format("net.tcp://{0}:" + portNumber + "/management-service", address)))
        {        
            
        }

        public ProvisionInstanceResponse ProvisionGroupVoiceInstance(string instanceIdentifier, Guid groupID, string joinCode, string apiKey)
        {
            return Channel.ProvisionGroupVoiceInstance(instanceIdentifier, groupID, joinCode, apiKey);
        }
     
        public ProvisionInstanceResponse ProvisionTypedVoiceInstance(string instanceIdentifier, int ownerUserID, VoiceInstanceType type, string apiKey)
        {
            return Channel.ProvisionTypedVoiceInstance(instanceIdentifier, ownerUserID, type, apiKey);
        }

        public ProvisionInstanceResponse ProvisionGroupVoiceInstanceV2(string apiKey, string instanceIdentifier, Guid groupID, string joinCode, VoiceInstanceMode mode)
        {
            return Channel.ProvisionGroupVoiceInstanceV2(apiKey, instanceIdentifier, groupID, joinCode, mode);
        }

        public ProvisionInstanceResponse ProvisionTypedVoiceInstanceV2(string apiKey, string instanceIdentifier, int ownerUserID, VoiceInstanceType type, VoiceInstanceMode mode)
        {
            return Channel.ProvisionTypedVoiceInstanceV2(apiKey, instanceIdentifier, ownerUserID, type, mode);
        }

        public UnlockInstanceResponse UnlockVoiceInstance(string instanceIdentifier, string apiKey)
        {
            return Channel.UnlockVoiceInstance(instanceIdentifier, apiKey);
        }

        public KickUsersResponse KickUsers(string instanceIdentifier, int kickerUserID, int[] userIDsToKick, string apiKey)
        {
            return Channel.KickUsers(instanceIdentifier, kickerUserID, userIDsToKick, apiKey);
        }

        public RemoveUsersResponse RemoveUsers(string instanceIdentifier, int requestorUserID, int[] userIDsToRemove, UserDisconnectReason reason, string apiKey)
        {
            return Channel.RemoveUsers(instanceIdentifier, requestorUserID, userIDsToRemove, reason, apiKey);
        }

        public AddPendingUsersResponse AddPendingUsers(string instanceIdentifier, PendingUserRequest[] pendingUsers, string apiKey)
        {
            return Channel.AddPendingUsers(instanceIdentifier, pendingUsers, apiKey);
        }

        public RemovePendingUserResponse RemovePendingUser(string instanceIdentifier, int curseUserID, string apiKey)
        {
            return Channel.RemovePendingUser(instanceIdentifier, curseUserID, apiKey);
        }

        public DestoryInstanceResponse DestroyVoiceInstance(string instanceIdentifier, string apiKey)
        {         
            return Channel.DestroyVoiceInstance(instanceIdentifier, apiKey);
        }

        public InstanceDetailsResponse GetInstanceDetails(string apiKey, Guid instanceIdentifier)
        {
            return Channel.GetInstanceDetails(apiKey, instanceIdentifier);
        }

        public StatisticsResponse GetStatistics(string apiKey)
        {
            return Channel.GetStatistics(apiKey);
        }

        public InstanceStatisticsResponse GetInstanceStatistics(string apiKey)
        {
            return Channel.GetInstanceStatistics(apiKey);
        }

        public ConnectionDiagnosticsResponse GetConnectionDiagnostics(string apiKey)
        {
            return Channel.GetConnectionDiagnostics(apiKey);
        }

        public FailoverServerResponse Failover(string apiKey, FailoverInstructions[] failovers)
        {
            return Channel.Failover(apiKey, failovers);
        }

        public FailoverServerResponse FailoverInstance(string apiKey, FailoverInstructions failover)
        {
            return Channel.FailoverInstance(apiKey, failover);
        }

        public UpdateUserPermissionsResponse UpdateUserPermissions(string instanceIdentifier, VoiceUserPermissions[] userPermissions, string apiKey)
        {
            return Channel.UpdateUserPermissions(instanceIdentifier, userPermissions, apiKey);
        }

        public MuteUserResponse MuteUser(string instanceIdentifier, int requestorUserID, int mutedUserID, bool mute, string apiKey)
        {
            return Channel.MuteUser(instanceIdentifier, requestorUserID, mutedUserID, mute, apiKey);
        }

        public DeafenUserResponse DeafenUser(string instanceIdentifier, int requestorUserID, int deafenedUserID, bool deafen, string apiKey)
        {
            return Channel.DeafenUser(instanceIdentifier, requestorUserID, deafenedUserID, deafen, apiKey);
        }

        public bool UpdateConfiguration(string apiKey, VoiceHostConfigurationContract configuration)
        {
            return Channel.UpdateConfiguration(apiKey, configuration);
        }
    }
}
