﻿using System;
using System.Configuration;
using System.IO;
using System.Xml.Serialization;

namespace Curse.Voice.HostRuntime
{
    public enum ConfigurationMode
    {
        Debug,        
        Staging,
        Beta,
        Release,
        LoadTesting
    }
    
    
    [XmlType("HostRuntime")]
    public class HostRuntimeConfiguration
    {
        public static ConfigurationMode Mode { get; private set; }

        private static readonly HostRuntimeConfiguration _instance = null;

        public static HostRuntimeConfiguration Instance
        {
            get { return _instance; }
        }

        static HostRuntimeConfiguration()
        {

#if CONFIG_DEBUG
            Mode = ConfigurationMode.Debug;
#elif CONFIG_STAGING
            Mode = ConfigurationMode.Staging;
#elif CONFIG_BETA
            Mode = ConfigurationMode.Beta;
#elif CONFIG_RELEASE
            Mode = ConfigurationMode.Release;
#elif CONFIG_LOADTESTING
            Mode = ConfigurationMode.LoadTesting;
#endif

            // Try to load the config, based on the compilation mode
            var configPath = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "Configuration", "HostRuntime." + Mode + ".config");

            if (!File.Exists(configPath))
            {
                throw new ConfigurationErrorsException("Configuration could not be loaded from '" + configPath + "'");
            }

            using (var reader = new StreamReader(configPath))
            {
                var dcs = new XmlSerializer(typeof(HostRuntimeConfiguration));
                _instance = (HostRuntimeConfiguration)dcs.Deserialize(reader);
            }
            
        }

        [XmlElement()]
        public int ManagementPortNumber { get; set; }
      
        [XmlArray()]
        [XmlArrayItem("Port")]
        public int[] VoicePortNumbers { get; set; }

        [XmlElement()]
        public int MaxConnections { get; set; }

        [XmlElement()]
        public string CentralServiceUrl { get; set; }

        [XmlElement()]
        public string CentralServiceApiKey { get; set; }

        [XmlElement()]
        public int MaxUsersPerVoiceSession { get; set; }

        [XmlElement()]
        public int MaxUsersPerVideoSession { get; set; }
        
        [XmlElement]
        public string EncryptionKey { get; set; }

        [XmlElement]
        public int EncryptionIterations { get; set; }
        
        [XmlElement]
        public int PendingUserTimeout { get; set; }

        [XmlElement]
        public string CertificateSubject { get; set; }

        [XmlElement()]
        public string LogServiceUrl { get; set; }

        [XmlElement()]
        public string LogServiceApiKey { get; set; }
    }
}
