﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.ServiceModel;
using System.Text;
using System.Threading.Tasks;
using Curse.Voice.Host;
using Curse.Voice.HostInterface;
using Curse.Voice.HostManagement;

namespace Curse.Voice.HostRuntime
{
    public class VoiceInstanceHost : IDisposable
    {
        public ServiceHost Host { get; private set; }
        public VoiceInstance VoiceInstance { get; private set; }
        private const int DefaultTimeout = 10;

        public VoiceInstanceHost(string instanceIdentifier, int ownerUserID, int port)
        {
            VoiceInstance = new VoiceInstance(instanceIdentifier, ownerUserID);            
            Host = TcpBindingHelper.CreateServiceHost<ICurseVoiceHost>(new VoiceHost(VoiceInstance), "net.tcp://" + Environment.MachineName + ":" + port + "/" + instanceIdentifier);
            Host.Open(TimeSpan.FromSeconds(DefaultTimeout));
        }

        public void Dispose()
        {
            if (Host != null)
            {
                try
                {
                    Host.Close(TimeSpan.FromSeconds(DefaultTimeout));
                    (Host as IDisposable).Dispose();
                }
                catch (Exception ex)
                {
                    
                    // Log this
                }
                
            }
        }
    }
}
