﻿using System;
using System.Collections.Generic;
using System.Linq;

namespace Curse.Voice.HostRuntime
{
    public class VoiceInstancePendingDisconnect
    {
        public static readonly List<VoiceInstancePendingDisconnect> PendingUsers = new List<VoiceInstancePendingDisconnect>();
        private static readonly TimeSpan PendingDisconnectLifespan = TimeSpan.FromSeconds(5);

        public static void AddPendingDisconnect(VoiceInstance parent, VoiceSession session)
        {
            var pendingDisconnect = new VoiceInstancePendingDisconnect()
            {
                DateCreated = DateTime.UtcNow,
                Parent = parent,
                Session = session,
            };
            
            lock (PendingUsers)
            {
                PendingUsers.Add(pendingDisconnect);
            }
        }

        public DateTime DateCreated { get; set; }
        public VoiceInstance Parent { get; set; }
        public VoiceSession Session { get; set; }

        public bool IsReady
        {
            get { return DateTime.UtcNow - DateCreated >= PendingDisconnectLifespan; }
        }

        public void Remove()
        {
            lock (PendingUsers)
            {
                PendingUsers.Remove(this);
                Parent = null;
            }
        }

        public static VoiceInstancePendingDisconnect[] GetReady()
        {
            VoiceInstancePendingDisconnect[] allPendingUsers;
            lock (PendingUsers)
            {
                allPendingUsers = PendingUsers.ToArray();
            }

            return allPendingUsers.Where(p => p.IsReady).ToArray();
        }       
    }
}
