﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using Curse.Logging;
using Curse.Voice.Contracts;

namespace Curse.Voice.HostRuntime
{
    public class VoiceInstancePendingUser
    {
        public static readonly List<VoiceInstancePendingUser> PendingUsers = new List<VoiceInstancePendingUser>();
        private static readonly TimeSpan PendingUserLifespan = TimeSpan.FromSeconds(HostRuntimeConfiguration.Instance.PendingUserTimeout);

        public VoiceInstancePendingUser(VoiceInstance parent, PendingUser user)
        {
            DateCreated = DateTime.UtcNow;
            Parent = parent;
            User = user;

            lock (PendingUsers)
            {
                PendingUsers.Add(this);
            }
        }

        public DateTime DateCreated { get; set; }
        public VoiceInstance Parent { get; set; }
        public PendingUser User { get; set; }

        public bool IsExpired
        {
            get { return DateTime.UtcNow - DateCreated >= PendingUserLifespan; }
        }

        public void Remove()
        {
            lock (PendingUsers)
            {
                PendingUsers.Remove(this);
                Parent = null;
            }
        }

        public static VoiceInstancePendingUser[] GetExpired()
        {
            VoiceInstancePendingUser[] allPendingUsers;
            lock (PendingUsers)
            {
                allPendingUsers = PendingUsers.ToArray();
            }

            return allPendingUsers.Where(p => p.IsExpired).ToArray();
        }       
    }
}
