﻿using System;
using System.Threading;
using Curse.Logging;
using Curse.Voice.Contracts;

namespace Curse.Voice.HostRuntime
{
    public class VoiceInstanceScheduler
    {
        public static void Start()
        {
            new Thread(RemoveExpiredThread) { IsBackground = true, Name = "VoiceInstancePendingUserThread" }.Start();
            new Thread(ProcessDisconnectsThread) { IsBackground = true, Name = "ProcessDisconnectsThread" }.Start();
        }

        private static void RemoveExpiredThread()
        {
            while (true)
            {
                try
                {
                    RemoveExpired();
                    Thread.Sleep(2000);
                }
                catch (ThreadAbortException)
                {
                    // Do nothing
                    return;
                }
                catch (Exception ex)
                {

                    Logger.Error(ex, "Failed to remove expired pending users.");
                }
            }
        }

        public static void RemoveExpired()
        {

            var expiredUsers = VoiceInstancePendingUser.GetExpired();
        
            foreach (var expiredUser in expiredUsers)
            {
                var voiceInstance = expiredUser.Parent;
                var user = expiredUser.User;
                if (voiceInstance != null)
                {
                    voiceInstance.RemovePendingUser(user.UserID, RemovePendingUserReason.NoAnswer);
                }
                else
                {
                    expiredUser.Remove();
                }
            }
        }

        private static void ProcessDisconnectsThread()
        {
            while (true)
            {
                try
                {
                    ProcessDisconnects();
                    Thread.Sleep(1000);
                }
                catch (ThreadAbortException)
                {
                    // Do nothing
                    return;
                }
                catch (Exception ex)
                {

                    Logger.Error(ex, "Failed to remove expired pending users.");
                }
            }
        }

        public static void ProcessDisconnects()
        {

            var expiredUsers = VoiceInstancePendingDisconnect.GetReady();

            foreach (var expiredUser in expiredUsers)
            {
                if (expiredUser.Session.IsPendingDisconnect)
                {
                    expiredUser.Session.ForceDisconnect();
                    
                }
                expiredUser.Remove();
            }
        }
    }
}
