﻿using System;
using System.Diagnostics;
using System.IO;
using Curse.Logging;
using Curse.Logging.Uploader;

namespace Curse.Voice.HostRuntime
{
    public static class VoiceServerLog
    {        

        private static EventLog _eventLog;

      
        internal static void Initialize(EventLog eventLog, string machineKey)
        {
            _eventLog = eventLog;
            
            Logger.Init(BaseFolderPath, "VoiceHostRuntime");            
            LogUploader.Initialize(1, HostRuntimeConfiguration.Instance.LogServiceUrl, HostRuntimeConfiguration.Instance.LogServiceApiKey);            
            
        }

        public static string BaseFolderPath
        {
            get { return Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "Logs"); }
        }

        public static string FolderName
        {
            get { return "VoiceHostRuntime"; }
        }

        public static string FullFolderPath
        {
            get { return Path.Combine(BaseFolderPath, FolderName); }
        }

        private static void WriteToEventLog(string message, EventLogEntryType type = EventLogEntryType.Information)
        {
            if (_eventLog == null)
            {
                return;
            }

            _eventLog.WriteEntry(message, type);
        }

        public static void Debug(string message)
        {
            Logger.Debug(message);
        }

        public static void Info(string message, bool writeToEventLog = false, object data = null)
        {
            Logger.Info(message, data);            
            if (writeToEventLog)
            {
                WriteToEventLog(message);
            }
        }

        public static void Warn(string message, object data = null, bool writeToEventLog = false)
        {
            Logger.Warn(message, data);
            if (writeToEventLog)
            {
                WriteToEventLog(message, EventLogEntryType.Warning);
            }
        }

        public static void Error(string message)
        {
            message = message ?? "Exception Occured";
            Logger.Error(message);
        }

        public static void Exception(Exception ex, string message = null, bool writeToEventLog = false)
        {
            message = message ?? "Exception Occured";            
            Logger.Error(ex, message);
        }

        public static void Shutdown()
        {            
            try
            {                
                LogUploader.Shutdown();
            }
            catch (Exception ex)
            {
#if DEBUG
                if (Debugger.IsAttached)
                {
                    Debugger.Break();
                }
#endif
            }
        }                       
    }
}
