﻿using System.Diagnostics;
using System.Net;
using System.Runtime;
using System.Runtime.CompilerServices;
using System.ServiceModel;
using System;
using System.Collections.Generic;
using System.Linq;
using System.ServiceModel.Channels;
using System.Text;
using System.Threading.Tasks;
using System.Threading;
using System.ServiceModel.Description;
using Curse.SocketInterface;
using Curse.SocketMessages;
using Curse.Voice.Client;
using Curse.Voice.Contracts;
using Curse.Voice.HostManagement;
using Curse.Voice.HostManagement.Responses;

namespace Curse.Voice.HostTests
{
    class Program
    {

#if DEBUG
        public const int PortNumber = 6100;
#else
        public const int PortNumber = 80;
#endif

        static int _pendingRequests = 0;
        private static byte[] _testBytes;
        private static bool _isAlive = true;

        public const string ApiKey = "***REMOVED***";

        static void Main(string[] args)
        {
            try
            {
                const string ipAddr = "10.130.20.112";
                var addr = IPAddress.Parse(ipAddr);

                var client = CreateNewClient(ipAddr);
                var sessions = new StressSession[1];
                for (var i = 0; i < sessions.Length; ++i)
                {
                    sessions[i] = new StressSession(client, addr);
                }

                var stats = client.GetInstanceStatistics(Program.ApiKey);

                Console.WriteLine("Got {0} stats", stats.Statistics.Length);
                foreach (var stat in stats.Statistics)
                {
                    Console.WriteLine("Id: {0}  Users: {1} Inbound: {2} Outbound: {3} Created: {4}",
                        stat.Identifier,
                        stat.UserCount,
                        stat.InboundVoiceDataCounter,
                        stat.OutboundVoiceDataCounter,
                        stat.DateCreated);
                }

                GC.Collect();
                Console.WriteLine("Gen0: {0}", GC.CollectionCount(0));

                var start = Stopwatch.GetTimestamp();
                var n = 1000;
                var delta = Stopwatch.Frequency/50;
                var next = Stopwatch.GetTimestamp() + delta;
                for (var i = 0; i < n; ++i)
                {
                    // Busy wait for the right send interval
                    while (true)
                    {
                        if (Stopwatch.GetTimestamp() - next >= 0)
                            break;
                    }
                    next += delta;

                    for (var j = 0; j < sessions.Length; ++j)
                    {
                        sessions[j].RunStep();
                    }
                }
                var end = Stopwatch.GetTimestamp();
                var duration = (end - start)/(double)Stopwatch.Frequency;
                Console.WriteLine("{0}pps", n / duration);

                //for (var i = 0; i < sessions.Length; ++i)
                {
                    sessions[0].Wait();
                }

                Console.WriteLine("Gen0: {0}", GC.CollectionCount(0));

                for (var i = 0; i < sessions.Length; ++i)
                {
                    sessions[i].Report(n);
                }

                Console.ReadLine();
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex);
            }
        }

        private static VoiceManagementClient CreateNewClient(string ipAddress, int portNumber = 8080)
        {
            return new VoiceManagementClient(new InstanceContext(new VoiceHostCallbackClient()), ipAddress, portNumber);
        }

        public static VoiceClient Connect(string id, IPAddress addr, int port, string name, int userId)
        {
            JoinSessionResponse response;
            var client = VoiceClient.Connect(new[] {port},
                new VoiceConnectionInfo(new CodecInfo
                {
                    Name = "Opus",
                    PacketMilliseconds = 40,
                    SampleRate = 44100,
                })
                {
                    InviteUrl = null,
                    OriginalDisplayName = null,
                    DisplayName = name,
                    HostID = 0,
                    HostName = null,
                    IPAddress = addr,
                    Port = PortNumber,
                    InstanceID = id,
                    UserID = userId,
                    GameID = null,
                    AvatarUrl = null,
                    InGameName = null,
                    InGameRegion = null,
                    RegionName = null,
                    AuthToken = null,
                    AccessToken = null,
                }, false, "7.0.0.0", out response);
            Console.WriteLine("Join: {0} ({1})", response.Status, name);

            return client;
        }

        public class RxStats
        {
            public long FirstRx;
            public long LastRx;
            public int Count;

            public double Elapsed { get { return (LastRx - FirstRx)/(double)Stopwatch.Frequency; } }
            public double Rate { get { return Count/Elapsed; } }

            private double _mean;
            private double _M2;

            public double Mean { get { return 1000*_mean/Stopwatch.Frequency; } }
            public double StdDev { get { return Mean/(Count - 1); }}

            private long _min = long.MaxValue;
            private long _max = long.MinValue;

            public double Min { get { return 1000*_min/(double)Stopwatch.Frequency; } }
            public double Max { get { return 1000*_max/(double)Stopwatch.Frequency; } }

            public void OnReceive(object sender, EventArgs<TransmitNotification> notification)
            {
                ++Count;
                var now = Stopwatch.GetTimestamp();
                var x = now - LastRx;
                LastRx = now;

                if (FirstRx == 0)
                {
                    FirstRx = now;
                }
                else
                {
                    if (x < _min) _min = x;
                    if (x > _max) _max = x;

                    var delta = x - _mean;
                    _mean += delta/Count;
                    _M2 += delta*(x - _mean);
                }
            }
        }

        static void OldMain(string[] args)
        {
            string username = null;
            if (args.Length == 0)
            {
                Console.Write("What's your username? ");
                username = Console.ReadLine();
            }
            else
            {
                username = args[0];
            }

            for (int i = 0; i < 100; i++)
            {
                Console.WriteLine(username + "-" + i);
                string sessionUsername = username + "-" + i;
                bool transmit = i == 0;
                new Thread(() => Connect(sessionUsername, transmit)).Start();
                Thread.Sleep(10);
            }


            Console.ReadLine();
            return;
            

            var bytes = new byte[640];
            for (int i = 0; i < 640; i++)
            {
                bytes[i] = 1;
            }
            _testBytes = bytes;

            DateTime startTime = DateTime.UtcNow;
            
            for (int i = 1; i < 1000; i++)
            {
                Interlocked.Increment(ref _pendingRequests);
                //new Thread(() => DoWork("Test-" + i.ToString())).Start();                
            }
            
            Console.WriteLine("Launched " + _pendingRequests.ToString("###,##0") + " voice clients.");            
            Console.WriteLine("Press ENTER to stop.");

            while (true)
            {
                var keyInfo = Console.ReadKey(true);
                if(keyInfo.Key == ConsoleKey.Enter)
                {
                    _isAlive = false;
                    break;                    
                }                
            }

            Console.WriteLine("Completed in " + (DateTime.UtcNow - startTime).TotalSeconds.ToString("###,##0.00") + " seconds");
            
        }

        static Dictionary<int, VoiceSessionMember> _users = new Dictionary<int, VoiceSessionMember>();

        private static void CreateSession(string username, string instanceID = "Test-0")
        {
            VoiceManagementClient managementClient = new VoiceManagementClient(new InstanceContext(new VoiceHostManagementCallbackClient()), Environment.MachineName, 82);

            var managementResp = managementClient.ProvisionVoiceInstance(instanceID, 1, "");

            if (managementResp.Status == ProvisionInstanceStatus.FailedAlreadyExists)
            {
                managementClient.DestroyVoiceInstance(instanceID, "");

                managementResp = managementClient.ProvisionVoiceInstance(instanceID, 1, "");
            }

            if (managementResp.Status != ProvisionInstanceStatus.Successful)
            {
                Console.WriteLine("Failed to create instance: " + managementResp.Status.ToString());
                return;
            }
        }
       

        static void Connect(string username, bool transmit, string instanceID = "Test")
        {
            var connectInfo = new VoiceConnectionInfo(new CodecInfo {Name = "opus", PacketMilliseconds = 40})
            {
                InviteUrl = null,
                OriginalDisplayName = null,
                DisplayName = username,
                HostID = 0,
                HostName = null,
                IPAddress = IPAddress.Parse("127.0.0.1"),
                Port = PortNumber,
                InstanceID = instanceID,
                UserID = 1,
                GameID = null,
                AvatarUrl = null,
                InGameName = null,
                InGameRegion = null,
                RegionName = null,
                AuthToken = null,
                AccessToken = null,
            };

            //var client = VoiceClient.Connect("localhost", PortNumber, instanceID, username, null, 1);
            JoinSessionResponse response;
            var client = VoiceClient.Connect(new[] { PortNumber }, connectInfo, false, "7.0.0.0", out response);
            //client.Connected += ClientOnConnected;

            if (response != null && response.Status != JoinSessionStatus.Successful)
            {
                Console.WriteLine("Unable to join: " + response.Status);
                return;
            }

            if (client == null || response == null)
            {
                Console.WriteLine("Unable to join");
                return;
            }

            client.IncomingChannelProcessor.Trace("ClientOnJoined with ClientID: " + response.ClientID);
            _users = response.Users.ToDictionary(p => p.ClientID);
            var existingUsers = string.Join(", ", _users.Values.Select(p => p.DisplayName).ToArray());
            //Console.WriteLine("The following people are already here: " + existingUsers);

            new Thread(() => PacketThread(client)).Start();
        }


        //private static void CallbackClientOnOnReceiveChatMessage(object sender, EventArgs<ChatMessage> eventArgs)
        //{
        //    var chatMessage = eventArgs.Value;
        //    VoiceUser user;
        //    if(_users.TryGetValue(eventArgs.Value.AuthorUserID, out user))
        //    {
        //        Console.WriteLine("[" + user.DisplayName + "] " + chatMessage.Body);
        //    }
            
        //}

        //private static void CallbackClientOnOnUserLeft(object sender, EventArgs<int> eventArgs)
        //{
        //    if (_users.ContainsKey(eventArgs.Value))
        //    {
        //        _users.Remove(eventArgs.Value);
        //    }
        //    Console.WriteLine("User " + eventArgs.Value + " has left");
        //}

        //private static void CallbackClientOnOnEndTransmission(object sender, EventArgs<int> eventArgs)
        //{
        //    Console.WriteLine("User " + eventArgs.Value + " has stopped talking");
        //}

        //private static void CallbackClientOnOnUserUpdate(object sender, EventArgs<VoiceUser> eventArgs)
        //{
        //    if (_users.ContainsKey(eventArgs.Value.ID))
        //    {
        //        _users[eventArgs.Value.ID] = eventArgs.Value;
        //    }
        //    Console.WriteLine("User " + eventArgs.Value.DisplayName + " has been updated");
        //}

        //private static void CallbackClientOnOnUserJoined(object sender, EventArgs<VoiceUser> eventArgs)
        //{
        //    if (!_users.ContainsKey(eventArgs.Value.ID))
        //    {
        //        _users.Add(eventArgs.Value.ID, eventArgs.Value);
        //    }

        //    Console.WriteLine("User " + eventArgs.Value.DisplayName + " has joined");
        //}

        //private static void CallbackClientOnOnTransmission(object sender, EventArgs<IncomingVoiceTransmission> eventArgs)
        //{
            
        //}

        static bool _transmit = false;

        static void PacketThread(VoiceClient client)
        {
            int bytesPerSend = 255;
            var testBytes = new byte[bytesPerSend];

            for (int i = 0; i < bytesPerSend; i++)
            {
                testBytes[i] = (byte)i;
            }

            while (true)
            {                
                client.SendPacket(new TestContract() { Message = testBytes });
                Thread.Sleep(5000);                
            }
        }       

        static void TransmissionThread(VoiceClient client)
        {
            int bytesPerSend = 40;
            int millisecondsPerSend = 20;
            int bytesPerSecond = (1000 / millisecondsPerSend) * bytesPerSend;

            var testBytes = new byte[bytesPerSend];
            
            for(int i = 0; i < bytesPerSend; i++)
            {
                testBytes[i] = (byte)i;
            }

            while (true)
            {
                Thread.Sleep(0);

                if (true || _transmit)
                {
                    client.Transmit(testBytes);
                    Thread.Sleep(20);
                }
            }
        }              
    }
}
