﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Net;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using Curse.Voice.Client;
using Curse.Voice.Contracts;
using Curse.Voice.HostManagement;

namespace Curse.Voice.HostTests
{
    class StressSession
    {
        private VoiceClient[] _clients;
        private Program.RxStats[] _rxStats;
        private byte[] _data;

        public StressSession(VoiceManagementClient client, IPAddress addr, int packetSize = 600)
        {
            var id = Guid.NewGuid().ToString();
            var r = client.ProvisionTypedVoiceInstance(id, 1, VoiceInstanceType.AdHoc, Program.ApiKey);
            Console.WriteLine("Id: {0} Response: {1}", id, r.Status);

            _clients = new VoiceClient[5];
            _rxStats = new Program.RxStats[_clients.Length];
            for (var i = 1; i <= _clients.Length; ++i)
            {
                var c = Program.Connect(id, addr, Program.PortNumber, "zusername-" + i, i);
                var rx = new Program.RxStats();
                c.VoiceTranmission += rx.OnReceive;
                _clients[i - 1] = c;
                _rxStats[i - 1] = rx;
            }

            _data = new byte[packetSize];
        }

        public void RunStep()
        {
            _clients[0].Transmit(_data);
        }

        public void Wait()
        {
            while (true)
            {
                var count = _rxStats[1].Count;
                Thread.Sleep(2000);
                if (_rxStats[1].Count <= count)
                    break;
            }
        }

        public void Report(int n)
        {
            var pps = 0.0;
            for (var i = 1; i < _rxStats.Length; ++i)
            {
                var s = _rxStats[i];
                var count = s.Count;
                var rate = s.Rate;
                var est = rate * n / count;
                Console.WriteLine("Rx{0}: {1} {2}pps ({3}pps est) Jitter: {4} +/- {5} ({6}-{7})",
                    i, count, rate, est, s.Mean, s.StdDev, s.Min, s.Max);

                pps += est;
            }

            Console.WriteLine();
            pps /= _clients.Length - 1;
            Console.WriteLine("Tx0: {0} {1}pps est (over {2}s)", n, pps, n / pps);
            Console.WriteLine();
        }
    }
}
