using Curse.ServiceClients.Contracts;
using System;

namespace Curse.ServiceClients
{
    public abstract class ServiceUrls
    {
			public abstract string Account { get; }
			public abstract string Bugs { get; }
			public abstract string Feedback { get; }
			public abstract string CallsAdmin { get; }
			public abstract string Calls { get; }
			public abstract string FriendSuggestions { get; }
			public abstract string FriendSync { get; }
			public abstract string Friendships { get; }
			public abstract string Contacts { get; }
			public abstract string Users { get; }
			public abstract string Conversations { get; }
			public abstract string Giveaways { get; }
			public abstract string GroupsApi { get; }
			public abstract string Groups { get; }
			public abstract string Invitations { get; }
			public abstract string PrivateMessages { get; }
			public abstract string Servers { get; }
			public abstract string Poll { get; }
			public abstract string Session { get; }
			public abstract string LinkedCommunities { get; }
			public abstract string LinkedAccounts { get; }
			public abstract string Login { get; }
			public abstract string Register { get; }
			public abstract string Stats { get; }

    }

    public abstract class BaseServices
    {
        public static ServiceUrls Urls;

		public readonly AccountService Account;
		public readonly BugsService Bugs;
		public readonly FeedbackService Feedback;
		public readonly CallsAdminService CallsAdmin;
		public readonly CallsService Calls;
		public readonly FriendSuggestionsService FriendSuggestions;
		public readonly FriendSyncService FriendSync;
		public readonly FriendshipsService Friendships;
		public readonly ContactsService Contacts;
		public readonly UsersService Users;
		public readonly ConversationsService Conversations;
		public readonly GiveawaysService Giveaways;
		public readonly GroupsApiService GroupsApi;
		public readonly GroupsService Groups;
		public readonly InvitationsService Invitations;
		public readonly PrivateMessagesService PrivateMessages;
		public readonly ServersService Servers;
		public readonly PollService Poll;
		public readonly SessionService Session;
		public readonly LinkedCommunitiesService LinkedCommunities;
		public readonly LinkedAccountsService LinkedAccounts;
		public readonly LoginService Login;
		public readonly RegisterService Register;
		public readonly StatsService Stats;


        protected BaseServices()
        {
			try
			{
				Account = new AccountService(Urls.Account);
			}
			catch (Exception ex)
			{
				ServicesConfiguration.LogError(ex, "Failed to create service client Account");
			}

			try
			{
				Bugs = new BugsService(Urls.Bugs);
			}
			catch (Exception ex)
			{
				ServicesConfiguration.LogError(ex, "Failed to create service client Bugs");
			}

			try
			{
				Feedback = new FeedbackService(Urls.Feedback);
			}
			catch (Exception ex)
			{
				ServicesConfiguration.LogError(ex, "Failed to create service client Feedback");
			}

			try
			{
				CallsAdmin = new CallsAdminService(Urls.CallsAdmin);
			}
			catch (Exception ex)
			{
				ServicesConfiguration.LogError(ex, "Failed to create service client CallsAdmin");
			}

			try
			{
				Calls = new CallsService(Urls.Calls);
			}
			catch (Exception ex)
			{
				ServicesConfiguration.LogError(ex, "Failed to create service client Calls");
			}

			try
			{
				FriendSuggestions = new FriendSuggestionsService(Urls.FriendSuggestions);
			}
			catch (Exception ex)
			{
				ServicesConfiguration.LogError(ex, "Failed to create service client FriendSuggestions");
			}

			try
			{
				FriendSync = new FriendSyncService(Urls.FriendSync);
			}
			catch (Exception ex)
			{
				ServicesConfiguration.LogError(ex, "Failed to create service client FriendSync");
			}

			try
			{
				Friendships = new FriendshipsService(Urls.Friendships);
			}
			catch (Exception ex)
			{
				ServicesConfiguration.LogError(ex, "Failed to create service client Friendships");
			}

			try
			{
				Contacts = new ContactsService(Urls.Contacts);
			}
			catch (Exception ex)
			{
				ServicesConfiguration.LogError(ex, "Failed to create service client Contacts");
			}

			try
			{
				Users = new UsersService(Urls.Users);
			}
			catch (Exception ex)
			{
				ServicesConfiguration.LogError(ex, "Failed to create service client Users");
			}

			try
			{
				Conversations = new ConversationsService(Urls.Conversations);
			}
			catch (Exception ex)
			{
				ServicesConfiguration.LogError(ex, "Failed to create service client Conversations");
			}

			try
			{
				Giveaways = new GiveawaysService(Urls.Giveaways);
			}
			catch (Exception ex)
			{
				ServicesConfiguration.LogError(ex, "Failed to create service client Giveaways");
			}

			try
			{
				GroupsApi = new GroupsApiService(Urls.GroupsApi);
			}
			catch (Exception ex)
			{
				ServicesConfiguration.LogError(ex, "Failed to create service client GroupsApi");
			}

			try
			{
				Groups = new GroupsService(Urls.Groups);
			}
			catch (Exception ex)
			{
				ServicesConfiguration.LogError(ex, "Failed to create service client Groups");
			}

			try
			{
				Invitations = new InvitationsService(Urls.Invitations);
			}
			catch (Exception ex)
			{
				ServicesConfiguration.LogError(ex, "Failed to create service client Invitations");
			}

			try
			{
				PrivateMessages = new PrivateMessagesService(Urls.PrivateMessages);
			}
			catch (Exception ex)
			{
				ServicesConfiguration.LogError(ex, "Failed to create service client PrivateMessages");
			}

			try
			{
				Servers = new ServersService(Urls.Servers);
			}
			catch (Exception ex)
			{
				ServicesConfiguration.LogError(ex, "Failed to create service client Servers");
			}

			try
			{
				Poll = new PollService(Urls.Poll);
			}
			catch (Exception ex)
			{
				ServicesConfiguration.LogError(ex, "Failed to create service client Poll");
			}

			try
			{
				Session = new SessionService(Urls.Session);
			}
			catch (Exception ex)
			{
				ServicesConfiguration.LogError(ex, "Failed to create service client Session");
			}

			try
			{
				LinkedCommunities = new LinkedCommunitiesService(Urls.LinkedCommunities);
			}
			catch (Exception ex)
			{
				ServicesConfiguration.LogError(ex, "Failed to create service client LinkedCommunities");
			}

			try
			{
				LinkedAccounts = new LinkedAccountsService(Urls.LinkedAccounts);
			}
			catch (Exception ex)
			{
				ServicesConfiguration.LogError(ex, "Failed to create service client LinkedAccounts");
			}

			try
			{
				Login = new LoginService(Urls.Login);
			}
			catch (Exception ex)
			{
				ServicesConfiguration.LogError(ex, "Failed to create service client Login");
			}

			try
			{
				Register = new RegisterService(Urls.Register);
			}
			catch (Exception ex)
			{
				ServicesConfiguration.LogError(ex, "Failed to create service client Register");
			}

			try
			{
				Stats = new StatsService(Urls.Stats);
			}
			catch (Exception ex)
			{
				ServicesConfiguration.LogError(ex, "Failed to create service client Stats");
			}


        }        
    }
}
