using Curse.ServiceClients.Contracts;
using Curse.ServiceClients;
using System;
using System.Collections.Generic;


namespace Curse.ServiceClients
{
    public class ContactsService : BaseWebServiceClient
    {
        public ContactsService(string url) : base(url)
        {
            
        }

		public ServiceResponse<ContactsResponse> GetAll() {
			return Get<ContactsResponse>("contacts");
		}

		public ServiceResponse<ContactsResponse> GetRecent(long timestamp) {
			return Get<ContactsResponse>(string.Format("contacts/recent/{0}", timestamp));
		}

		public ServiceResponse<ContactUrlResponse> GetByUrl(string url) {
			return Post<ContactUrlResponse>("contacts/url", url);
		}


    }
}
