using Curse.ServiceClients.Contracts;
using Curse.ServiceClients;
using System;
using System.Collections.Generic;


namespace Curse.ServiceClients
{
    public class ConversationsService : BaseWebServiceClient
    {
        public ConversationsService(string url) : base(url)
        {
            
        }

		public ServiceResponse<ConversationMessageNotification[]> History(string id, long endTimestamp, int pageSize) {
			return Get<ConversationMessageNotification[]>(string.Format("conversations/{0}", id) + string.Format("?endTimestamp={0}&pageSize={1}",endTimestamp,pageSize));
		}

		public ServiceResponse EditAttachment(string conversationID, string attachmentID, ConversationAttachmentEditRequest request) {
			return Post(string.Format("conversations/{0}/attachments/{1}", conversationID, attachmentID), request);
		}

		public ServiceResponse DeleteAttachment(string conversationID, string attachmentID, ConversationDeleteAttachmentRequest request) {
			return Delete(string.Format("conversations/{0}/attachments/{1}", conversationID, attachmentID) + string.Format("?request={0}",request));
		}

		public ServiceResponse<ConversationSearchItem[]> Search(string conversationID, ConversationSearchRequest searchFilters) {
			return Post<ConversationSearchItem[]>(string.Format("conversations/{0}/search", conversationID), searchFilters);
		}

		public ServiceResponse EditMessage(string conversationID, string id, long timestamp, ConversationEditMessageRequest request) {
			return Post(string.Format("conversations/{0}/{1}-{2}", conversationID, id, timestamp), request);
		}

		public ServiceResponse DeleteMessage(string conversationID, string id, long timestamp) {
			return Delete(string.Format("conversations/{0}/{1}-{2}", conversationID, id, timestamp));
		}

		public ServiceResponse LikeMessage(string conversationID, string id, long timestamp) {
			return Post(string.Format("conversations/{0}/{1}-{2}/like", conversationID, id, timestamp));
		}

		public ServiceResponse UnlikeMessage(string conversationID, string id, long timestamp) {
			return Post(string.Format("conversations/{0}/{1}-{2}/unlike", conversationID, id, timestamp));
		}


    }
}
