using Curse.ServiceClients.Contracts;
using Curse.ServiceClients;
using System;
using System.Collections.Generic;


namespace Curse.ServiceClients
{
    public class FriendSyncService : BaseWebServiceClient
    {
        public FriendSyncService(string url) : base(url)
        {
            
        }

		public ServiceResponse Upload(FriendHintContract[] identities) {
			return Post("friend-sync", identities);
		}

		public ServiceResponse<FriendHintContract[]> Get() {
			return Get<FriendHintContract[]>("friend-sync");
		}

		public ServiceResponse Delete(long id) {
			return Delete(string.Format("friend-sync/{0}", id));
		}

		public ServiceResponse Search(FriendListSearchRequest request) {
			return Post("friend-sync/search", request);
		}


    }
}
