using Curse.ServiceClients.Contracts;
using Curse.ServiceClients;
using System;
using System.Collections.Generic;


namespace Curse.ServiceClients
{
    public class FriendshipsService : BaseWebServiceClient
    {
        public FriendshipsService(string url) : base(url)
        {
            
        }

		public ServiceResponse<FriendshipContract> Get(int friendID) {
			return Get<FriendshipContract>(string.Format("friendship/{0}", friendID));
		}

		public ServiceResponse Confirm(int friendID) {
			return Post(string.Format("friendship/{0}/confirm", friendID));
		}

		public ServiceResponse Decline(int friendID) {
			return Delete(string.Format("friendship/{0}/decline", friendID));
		}

		public ServiceResponse Create(int friendID, FriendshipRequest request) {
			return Post(string.Format("friendship/{0}/create", friendID), request);
		}

		public ServiceResponse Unfriend(int friendID) {
			return Delete(string.Format("friendship/{0}/unfriend", friendID));
		}

		public ServiceResponse Unblock(int friendID) {
			return Post(string.Format("friendship/{0}/unblock", friendID));
		}

		public ServiceResponse Favorite(int friendID) {
			return Post(string.Format("friendship/{0}/favorite", friendID));
		}

		public ServiceResponse Unfavorite(int friendID) {
			return Post(string.Format("friendship/{0}/unfavorite", friendID));
		}

		public ServiceResponse<FriendOfFriendDetails[]> GetFriendsOfFriend(int friendID) {
			return Get<FriendOfFriendDetails[]>(string.Format("friendship/{0}/friends", friendID));
		}

		public ServiceResponse RenameFriend(int friendID, string nickname) {
			return Post(string.Format("friendship/{0}/rename", friendID), nickname);
		}

		public ServiceResponse<FriendSearchResponse> Search(string query) {
			return Get<FriendSearchResponse>("friendship/search" + string.Format("?query={0}",query));
		}

		public ServiceResponse ChangeFriendNotificationPreferences(int friendID, ChangeFriendshipPreferencesRequest request) {
			return Post(string.Format("friendship/{0}/preferences", friendID), request);
		}


    }
}
