using Curse.ServiceClients.Contracts;
using Curse.ServiceClients;
using System;
using System.Collections.Generic;


namespace Curse.ServiceClients
{
    public class GiveawaysService : BaseWebServiceClient
    {
        public GiveawaysService(string url) : base(url)
        {
            
        }

		public ServiceResponse<ActiveGiveawayResponse[]> GetMyActiveClaimWindows() {
			return Get<ActiveGiveawayResponse[]>("giveaways/pending-claims");
		}

		public ServiceResponse<ActiveGiveawayResponse> GetActive(Guid groupID) {
			return Get<ActiveGiveawayResponse>(string.Format("giveaways/{0}", groupID));
		}

		public ServiceResponse<GroupGiveawaySettingsNotification> GetLatestSettings(Guid groupID) {
			return Get<GroupGiveawaySettingsNotification>(string.Format("giveaways/{0}/settings", groupID));
		}

		public ServiceResponse<GroupGiveawayNotification> Create(Guid groupID, CreateGiveawayRequest request) {
			return Post<GroupGiveawayNotification>(string.Format("giveaways/{0}", groupID), request);
		}

		public ServiceResponse<GroupGiveawayNotification> Get(Guid groupID, int giveawayID) {
			return Get<GroupGiveawayNotification>(string.Format("giveaways/{0}/{1}", groupID, giveawayID));
		}

		public ServiceResponse Continue(Guid groupID, int giveawayID) {
			return Post(string.Format("giveaways/{0}/{1}/continues", groupID, giveawayID));
		}

		public ServiceResponse End(Guid groupID, int giveawayID, bool keepActive) {
			return Delete(string.Format("giveaways/{0}/{1}?keepActive={keepActive}", groupID, giveawayID));
		}

		public ServiceResponse Roll(Guid groupID, int giveawayID) {
			return Post(string.Format("giveaways/{0}/{1}/rolls", groupID, giveawayID));
		}

		public ServiceResponse<bool> Register(Guid groupID, int giveawayID, int? referrerUserID) {
			return Post<bool>(string.Format("giveaways/{0}/{1}/participation", groupID, giveawayID), referrerUserID);
		}

		public ServiceResponse Unregister(Guid groupID, int giveawayID) {
			return Delete(string.Format("giveaways/{0}/{1}/participation", groupID, giveawayID));
		}

		public ServiceResponse Claim(Guid groupID, int giveawayID) {
			return Post(string.Format("giveaways/{0}/{1}/claims", groupID, giveawayID));
		}

		public ServiceResponse<GroupGiveawayRollResult[]> GetHistory(Guid groupID, int? pageSize, int? pageNumber) {
			return Get<GroupGiveawayRollResult[]>(string.Format("giveaways/{0}/history", groupID) + string.Format("?pageSize={0}&pageNumber={1}",pageSize,pageNumber));
		}

		public ServiceResponse<GroupGiveawayRollResult[]> SearchHistory(Guid groupID, GetGiveawayHistoryRequest request) {
			return Post<GroupGiveawayRollResult[]>(string.Format("giveaways/{0}/history/search", groupID), request);
		}


    }
}
