using Curse.ServiceClients.Contracts;
using Curse.ServiceClients;
using System;
using System.Collections.Generic;


namespace Curse.ServiceClients
{
    public class GroupsApiService : BaseWebServiceClient
    {
        public GroupsApiService(string url) : base(url)
        {
            
        }

		public ServiceResponse SetServerFeatured(Guid serverID, bool isFeatured) {
			return Post(string.Format("groups/api/{0}/featured", serverID), isFeatured);
		}

		public ServiceResponse AddOwner(Guid groupID, int userID) {
			return Post(string.Format("groups/api/{0}/members/owners", groupID), userID);
		}

		public ServiceResponse BlacklistVanityUrls(string[] urlsToBlacklist) {
			return Post("groups/api/vanity-urls/blacklists", urlsToBlacklist);
		}

		public ServiceResponse ReserveVanityUrls(string[] urlsToReserve) {
			return Post("groups/api/vanity-urls/reserves", urlsToReserve);
		}


    }
}
